package com.yeejoin.amos.boot.module.cylinder.flc.biz.controller;


import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.cylinder.api.dto.CylinderFillingMessageModel;
import com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl.CylinderAreaDataServiceImpl;
import com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl.DPStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "气瓶统计Api")
@RequestMapping(value = "/statistics")
public class CylinderStatisticsController {

    @Autowired
    private CylinderAreaDataServiceImpl service;
    @Autowired
    private DPStatisticsServiceImpl statisticsService;

    /**
     * 预警预报统计
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/earlyWarning", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "预警预报")
    public ResponseModel<Page<Map<String, Object>>> getEarlyWarning(@RequestParam(value = "regionCode", required = false) String regionCode, @RequestParam(value = "appId", required = false) String appId){
        return ResponseHelper.buildResponse(service.getEarlyWarningStatistics(regionCode, appId));
    }

    /**
     * 预警预报统计
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/earlyWarning/child", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "预警预报")
    public ResponseModel<Map<String, Object>> getChildEarlyWarning(@RequestBody Map<String, Object> map) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }

        return ResponseHelper.buildResponse(service.getChildEarlyWarning(regionCode.toString()));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/test/saveCylinderFillingRecord2ES", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "testSaveCylinderFillingRecord2ES")
    public ResponseModel testSaveCylinderFillingRecord2ES(){
        return ResponseHelper.buildResponse(service.testSaveCylinderFillingRecord2ES());
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "区域安全指数")
    @PostMapping(value = "/security-index")
    public ResponseModel<Map<String, Object>> getsecurityIndex(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }

        Map<String, Object> result = service.getsecurityIndex(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "问题类型主体统计")
    @PostMapping(value = "/mainBodyCount")
    public ResponseModel<Map<String, Object>> mainBodyCount(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = service.mainBodyCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "设备问题近30天统计")
    @PostMapping(value = "/equipmentCount")
    public ResponseModel<Map<String, Object>> equipmentCount(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = service.equipmentCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "企业问题近30天统计")
    @PostMapping(value = "/companyCount")
    public ResponseModel<List<Map<String, Object>>> companyCount(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = service.companyCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "人员问题近30天统计")
    @PostMapping(value = "/personCount")
    public ResponseModel<Map<String, Object>> personCount(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = service.personCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "气瓶问题近30天统计")
    @PostMapping(value = "/cylinderCount")
    public ResponseModel<Map<String, Object>> cylinderCount(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = service.cylinderCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "按月统计近12个月的问题数量趋势")
    @PostMapping(value = "/issueCountByMonth")
    public ResponseModel<Map<String, Object>> issueCountByMonth(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = service.issueCountByMonth(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "按月统计近30天的问题数量趋势")
    @PostMapping(value = "/issueCountByDay")
    public ResponseModel<Map<String, Object>> issueCountByDay(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = service.issueCountByDay(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "当前区域数据统计")
    @PostMapping(value = "/issueCountByCityCode")
    public ResponseModel<Map<String, Object>> issueCountByCityCode(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = service.issueCountByCityCode(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "当前区域子区域数据统计")
    @PostMapping(value = "/issueChildrenCityCount")
    public ResponseModel<List<Map<String, Object>>> issueChildrenCityCount(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = service.issueChildrenCityCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "当月问题列表（主体类型、问题类型、问题时间、操作）")
    @PostMapping(value = "/issueMonthList")
    public ResponseModel<List<Map<String, Object>>> issueMonthList(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = service.issueMonthList(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "当年问题等级分类统计")
    @PostMapping(value = "/issueProblemLevelCount")
    public ResponseModel<Map<String, Object>> issueProblemLevelCount(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        Map<String, Object> result = service.issueProblemLevelCount(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "按问题类型排名top 10")
    @PostMapping(value = "/issueCompanyTop")
    public ResponseModel<List<Map<String, Object>>> issueCompanyTop(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = service.issueCompanyTop(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-安全追溯-同设备近30天按问题次数滚动", notes = "大屏-安全追溯-同设备近30天按问题次数滚动")
    @PostMapping(value = "/aqzs/equip-question/list")
    public ResponseModel<List<Map<String, Object>>> getEquipQuestionList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getEquipQuestionList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "当年下级区域问题闭环率排名")
    @PostMapping(value = "/issueChildrenCityCountTop")
    public ResponseModel<List<Map<String, Object>>> issueChildrenCityCountTop(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = service.issueChildrenCityCountTop(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "按问题类型排名top 10")
    @PostMapping(value = "/issueCountTopByProblemType")
    public ResponseModel<List<Map<String, Object>>> issueCountTopByProblemType(@RequestBody Map<String, Object> map ) throws Exception {
        Object regionCode = map.get("cityCode");
        if (ObjectUtils.isEmpty(regionCode)) {
            regionCode = "610000";
        }
        List<Map<String, Object>> result = service.issueCountTopByProblemType(regionCode.toString());
        return ResponseHelper.buildResponse(result);
    };
}
