package com.yeejoin.amos.api.openapi.face.orm.dao;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.OpenapiBizToken;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * 
 * <pre>
 * Mapper 接口
 * </pre>
 *
 * @author gwb
 * @version $Id: OpenapiLogMapper.java, v 0.1 2021年11月10日 下午5:54:19 gwb Exp $
 */
public interface OpenapiBizTokenMapper extends BaseMapper<OpenapiBizToken> {


    @Select("SELECT " +
	            " * " +
	            " FROM " +
	            " iot_openapi_biz_token bt " +
	            " WHERE " +
	            " bt.APP_ID = '${appId}'")
	public OpenapiBizToken getByAppId(@Param("appId") String appId);


	@Select("select DEVELOPER_AGENCY from iot_openapi_biz_token  where DEVELOPER_AGENCY is not null AND DATA_TYPE = 'cyl' group by DEVELOPER_AGENCY")
	public List<String> getServiceList();

	@Select("select use_unit_code, use_unit from amos_tzs_biz.tz_base_enterprise_info where app_id = #{appId}")
	@DS("tzs")
	Map<String, String> queryUnitInfoByAppId(@Param("appId") String appId);
}	