package com.yeejoin.amos.boot.module.jg.biz.reminder.core.event.adapter;

import com.yeejoin.amos.boot.module.common.biz.constats.Constants;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.EmptyDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.event.EquipCreateOrEditEvent;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
@RequiredArgsConstructor
@Slf4j
public class BizDataChange2EditEventAdapter {

    private final ApplicationEventPublisher publisher;

    @TransactionalEventListener(phase = TransactionPhase.AFTER_COMMIT, value = {EmptyDataChangeEvent.class})
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void handleEventAsync(EmptyDataChangeEvent event) {
        log.info("receive editEvent handleEventAAsync eventA={}", event);
        try {
            publisher.publishEvent(convertToEvent(event));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

    }

    /**
     * 特殊处理由于其他业务类型还没评分准则，故使用设备或者装置的
     *
     * @param eventA 事件
     * @return 转换后事件
     */
    private EquipCreateOrEditEvent convertToEvent(EmptyDataChangeEvent eventA) {
        return new EquipCreateOrEditEvent(
                this,
                eventA.getBizRelationData().getProjectContraptionIds().isEmpty() ? Constants.JG_EDIT_EQUIP : Constants.JG_EDIT_PROJECT,
                eventA.getBizRelationData().getProjectContraptionIds().isEmpty() ? eventA.getBizRelationData().getRecords() : eventA.getBizRelationData().getProjectContraptionIds(),
                eventA.getBizRelationData().getProjectContraptionIds().isEmpty() ? EquipCreateOrEditEvent.EquipType.equip : EquipCreateOrEditEvent.EquipType.project
        );
    }
}
