package com.yeejoin.amos.boot.module.tzs.api.dto;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author tb
 * @date 2021-06-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tcb_elevator")
@ApiModel(value = "ElevatorDto", description = "ElevatorDto")
public class ElevatorDto extends BaseDto {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "电梯应急救援识别码")
    private Integer rescueCode;

    @ApiModelProperty(value = "设备注册代码")
    private String registerCode;

    @ApiModelProperty(value = "所属省")
    private String province;

    @ApiModelProperty(value = "所属地市")
    private String city;

    @ApiModelProperty(value = "所属区县")
    private String district;

    @ApiModelProperty(value = "所属区域代码")
    private String regionCode;

    @ApiModelProperty(value = "安装地址")
    private String address;

    @ApiModelProperty(value = "内部编号")
    private String innerNum;

    @ApiModelProperty(value = "电梯品牌")
    private String brand;

    @ApiModelProperty(value = "出厂编号")
    private String factoryNum;

    @ApiModelProperty(value = "电梯安装单位")
    private String installationUnit;

    @ApiModelProperty(value = "制造日期（出厂时间）")
    private Date factoryDate;

    @ApiModelProperty(value = "电梯大修/改造日期")
    private Date overhaulDate;

    @ApiModelProperty(value = "开始使用日期")
    private Date startUseDate;

    @ApiModelProperty(value = "设备类别")
    private String category;

    @ApiModelProperty(value = "设备类别code")
    private String categoryName;

    @ApiModelProperty(value = "使用场所分类")
    private String useSiteCategory;

    @ApiModelProperty(value = "使用场所分类名称")
    private String useSiteCategoryName;

    @ApiModelProperty(value = "电梯型号")
    private String model;

    @ApiModelProperty(value = "电梯层数")
    private Integer floors;

    @ApiModelProperty(value = "电梯站数")
    private Integer stations;

    @ApiModelProperty(value = "电梯门数")
    private Integer doors;

    @ApiModelProperty(value = "电梯额定速度(单位：m/s)")
    private Float ratedSpeed;

    @ApiModelProperty(value = "电梯额定载重量(单位：kg)")
    private Float ratedLoad;

    @ApiModelProperty(value = "最大荷载人数")
    private Integer maxPersonLoad;

    @ApiModelProperty(value = "提升高度")
    private Float raiseHeight;

    @ApiModelProperty(value = "拖动方式")
    private String dragMode;

    @ApiModelProperty(value = "拖动方式名称")
    private String dragModeName;

    @ApiModelProperty(value = "电梯使用状态")
    private Integer useStatus;

    @ApiModelProperty(value = "使用单位")
    private String useUnit;

    @ApiModelProperty(value = "使用单位id")
    private Long useUnitId;

    @ApiModelProperty(value = "制造单位名称")
    private String manufacturerName;

    @ApiModelProperty(value = "制造许可编号")
    private String manufacturingLicense;

    @ApiModelProperty(value = "维保类型")
    private String maintainType;

    @ApiModelProperty(value = "维保类型名称")
    private String maintainTypeName;

    @ApiModelProperty(value = "维护周期")
    private String maintainPeriod;

    @ApiModelProperty(value = "维护周期名称")
    private String maintainPeriodName;

    @ApiModelProperty(value = "维保单位")
    private String maintainUnit;

    @ApiModelProperty(value = "维保单位id")
    private Long maintainUnitId;

    @ApiModelProperty(value = "维保负责人")
    private String maintainLeader;

    @ApiModelProperty(value = "维保负责人id")
    private Long maintainLeaderId;

    @ApiModelProperty(value = "维保负责人手机")
    private String maintainLeaderPhone;

    @ApiModelProperty(value = "主机模式")
    private String hostModel;

    @ApiModelProperty(value = "主机编号")
    private String hostNum;

    @ApiModelProperty(value = "动力类型")
    private String engineType;

    @ApiModelProperty(value = "动力编号")
    private String engineNum;

    @ApiModelProperty(value = "面板模型")
    private String panelModel;

    @ApiModelProperty(value = "面板编号")
    private String panelNum;

    @ApiModelProperty(value = "级联模型")
    private String cascadeModel;

    @ApiModelProperty(value = "级联线路模型")
    private String cascadeLineModel;

    @ApiModelProperty(value = "扶手带类型")
    private String handrailType;

    @ApiModelProperty(value = "扶手面板模型")
    private String handrailPanelModel;

    @ApiModelProperty(value = "扶手面板品牌")
    private String handrailPanelBrand;

    @ApiModelProperty(value = "滚转机模式")
    private String rollerMode;

    @ApiModelProperty(value = "倾斜的角度")
    private String tiltAngle;

    @ApiModelProperty(value = "横向跨度")
    private String horizontalSpan;

    @ApiModelProperty(value = "运行噪音")
    private String runningNoise;

    @ApiModelProperty(value = "运行方式")
    private String runningMode;

    @ApiModelProperty(value = "运行振动")
    private String runningVibration;

    @ApiModelProperty(value = "功率")
    private String power;

    @ApiModelProperty(value = "原始表id（来自历史数据库）")
    private String originalId;

    @ApiModelProperty(value = "附件")
    private Map<String, List<AttachmentDto>> attachments;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;
}
