package com.yeejoin.amos.boot.module.common.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 通用的自定义字段转换器
 * 用于处理Excel导入导出时的字段转换逻辑
 */
@Component
public class CommonCustomConverter {

    private static RedisUtils redisUtils;

    public CommonCustomConverter(RedisUtils redisUtils) {
        CommonCustomConverter.redisUtils = redisUtils;
    }

    /**
     * 年月日格式转换器
     */
    public static class Y_M_D_DateConverter implements Converter<Date> {

        @Override
        public Class supportJavaTypeKey() {
            return null;
        }

        @Override
        public CellDataTypeEnum supportExcelTypeKey() {
            return null;
        }

        @Override
        public Date convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
            return null;
        }

        @Override
        public CellData convertToExcelData(Date value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
            if (value == null) {
                return new CellData("");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日");
            return new CellData(sdf.format(value));
        }
    }

    public static class ReceiveCompanyCodeConverter implements Converter<String> {

        public static Map<String, String> receiveCompanyCodeMap = new ConcurrentHashMap<>();
        public static List<LinkedHashMap<String, Object>> result = Lists.newArrayList();

        // 使用静态初始化块加载数据字典
        static {
            refreshCache();
        }

        /**
         * 刷新数据缓存
         */
        @SuppressWarnings("unchecked")
        public static void refreshCache() {
            result = (List<LinkedHashMap<String, Object>>) redisUtils.get("REGULATOR_UNIT_TREE");
        }

        @SuppressWarnings("unchecked")
        private static LinkedHashMap<String, Object> findCompanyByCode(List<LinkedHashMap<String, Object>> tree, String companyCode) {
            for (LinkedHashMap<String, Object> node : tree) {
                if (companyCode.equals(node.get("companyCode"))) {
                    return node;
                }
                if (node.containsKey("children") && node.get("children") instanceof List) {
                    LinkedHashMap<String, Object> foundNode = findCompanyByCode((List<LinkedHashMap<String, Object>>) node.get("children"), companyCode);
                    if (foundNode != null) {
                        return foundNode;
                    }
                }
            }
            return null;
        }

        @Override
        public Class<?> supportJavaTypeKey() {
            return String.class;
        }

        @Override
        public CellDataTypeEnum supportExcelTypeKey() {
            return CellDataTypeEnum.STRING;
        }

        @Override
        public String convertToJavaData(CellData cellData, ExcelContentProperty contentProperty,
                                        GlobalConfiguration globalConfiguration) {
            return null;
        }

        @Override
        public CellData convertToExcelData(String value, ExcelContentProperty contentProperty,
                                           GlobalConfiguration globalConfiguration) {
            return null;
        }

        public static String getNameByCode(String code) {
            LinkedHashMap<String, Object> company = findCompanyByCode(result, code);
            if (company == null) {
                return "";
            }
            return company.get("companyName").toString();
        }
    }
}
