package com.yeejoin.amos.api.openapi.enums;

/**
 * 
 * <pre>
 * 电梯轿厢运行方向枚举
 * </pre>
 *
 * @author gwb
 * @version $Id: LiftDirectionEnum.java, v 0.1 2021年9月29日 上午9:33:40 gwb Exp $
 */
public enum LiftDirectionEnum{

	No (1,"无方向"),
	Up (2,"上行"),
	Down (3,"下行");

	/**
	 * 编码
	 */
	private Integer code;

	/**
	 * 名称
	 */
	private String name;


	// 构造方法
	private LiftDirectionEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}


	public Integer getCode() {
		return code;
	}
	
	public String getName()
	{
		return name;
	}
	
	public static LiftDirectionEnum getEnum(Integer code)
	{
		for (LiftDirectionEnum liftDirectionEnum : LiftDirectionEnum.values())
		{
			if (liftDirectionEnum.getCode().equals(code))
			{
				return liftDirectionEnum;
			}
		}
		return null;
	}
}
