package com.yeejoin.amos.boot.module.jg.biz.reminder.core.event.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.common.biz.constats.Constants;
import com.yeejoin.amos.boot.module.common.biz.refresh.DataRefreshEvent;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.event.publisher.EventPublisher;
import com.yeejoin.amos.boot.module.jg.biz.reminder.biz.factory.GradeStrategyFactory;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.event.EquipCreateOrEditEvent;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.event.service.DefaultQualityScoreUpdateService;
import com.yeejoin.amos.boot.module.jg.biz.reminder.dto.MatchItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.service.CommonReminderService;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgUseInfoService;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgProjectContraptionServiceImplService;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Component
@RequiredArgsConstructor
public class ProjectQualityScoreUpdateService extends DefaultQualityScoreUpdateService {


    private final GradeStrategyFactory gradeStrategyFactory;

    private final IdxBizJgProjectContraptionServiceImplService idxBizJgProjectContraptionService;

    private final IIdxBizJgUseInfoService idxBizJgUseInfoService;

    private final EventPublisher eventPublisher;

    @Value("${grade.calculation.strategy:MAX_GRADE}")
    private String activeStrategy;

    private final ESEquipmentCategory equipmentCategoryDao;

    @Override
    public Boolean support(EquipCreateOrEditEvent.EquipType equipType) {
        return EquipCreateOrEditEvent.EquipType.project.equals(equipType);
    }

    private Integer getReminderLevel(String bizType, String projectContraptionId) {
        IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionService.getById(projectContraptionId);
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        matchItemDto.setBizType(bizType);
        matchItemDto.setEquList(projectContraption.getEquList());
        matchItemDto.setEquCategory(projectContraption.getEquCategory());
        matchItemDto.setEquDefine(projectContraption.getEquDefine());
        matchItemDto.setRegType(CommonReminderService.getRegTypeByDataSource(projectContraption.getDataSource()));
        matchItemDto.setIsRegister(projectContraption.getIsIntoManagement() && StringUtils.isNotEmpty(projectContraption.getUseRegistrationCode()));
        ReminderItemDto reminderItemDto = new ReminderItemDto();
        reminderItemDto.setEquipId(projectContraptionId);
        reminderItemDto.setEquipNo(projectContraption.getProjectContraptionNo());
        reminderItemDto.setEquipName(projectContraption.getProjectContraption());
        reminderItemDto.setDetailData(BeanUtil.beanToMap(projectContraption));
        return gradeStrategyFactory.getStrategy(activeStrategy).calculateGrade(Collections.singletonList(reminderItemDto), matchItemDto);
    }

    /**
     * 发送管道编辑信息-用于将装置下管道同步到
     *
     * @param projectContraptionIds 装置ids
     */
    private void sendDataRefreshMsg(Set<String> projectContraptionIds) {
        List<IdxBizJgUseInfo> useInfos = idxBizJgUseInfoService.list(new LambdaQueryWrapper<IdxBizJgUseInfo>()
                .in(IdxBizJgUseInfo::getProjectContraptionId, projectContraptionIds)
                .select(IdxBizJgUseInfo::getRecord));
        eventPublisher.publish(new DataRefreshEvent(this, useInfos.stream().map(IdxBizJgUseInfo::getRecord).collect(Collectors.toList()), DataRefreshEvent.DataType.equipment.name(), DataRefreshEvent.Operation.UPDATE));
    }

    @Override
    protected Boolean shouldProcess(String bizType) {
        return BusinessTypeEnum.JG_USAGE_REGISTRATION.name().equals(bizType) ||
                BusinessTypeEnum.JG_INSTALLATION_NOTIFICATION.name().equals(bizType) ||
                BusinessTypeEnum.JG_NEW_PROJECT.name().equals(bizType) ||
                Constants.JG_EDIT_PROJECT.equals(bizType);
    }

    @Override
    protected void doHandle(String bizType, Set<String> projectContraptionIds) {
        projectContraptionIds.forEach(projectContraptionId -> {
            Integer level = this.getReminderLevel(bizType, projectContraptionId);
            LambdaUpdateWrapper<IdxBizJgProjectContraption> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(IdxBizJgProjectContraption::getSequenceNbr, projectContraptionId);
            updateWrapper.set(IdxBizJgProjectContraption::getDataQualityScore, level);
            updateWrapper.set(BaseEntity::getRecDate, new Date());
            idxBizJgProjectContraptionService.update(updateWrapper);
            // 更新管道的等级与装置一样
            LambdaUpdateWrapper<IdxBizJgUseInfo> updateWrapper2 = new LambdaUpdateWrapper<>();
            updateWrapper2.eq(IdxBizJgUseInfo::getProjectContraptionId, projectContraptionId);
            updateWrapper2.set(IdxBizJgUseInfo::getDataQualityScore, level);
            idxBizJgUseInfoService.update(updateWrapper2);

            List<ESEquipmentCategoryDto> projectEquips = equipmentCategoryDao.findAllByProjectContraptionId(projectContraptionId);
            if (!ValidationUtil.isEmpty(projectEquips)) {
                for (ESEquipmentCategoryDto esEquipmentCategoryDto : projectEquips) {
                    esEquipmentCategoryDto.setDataQualityScore(level);
                }
                equipmentCategoryDao.saveAll(projectEquips);
            }
        });
    }

    @Override
    protected void afterHandle(Set<String> projectContraptionIds) {
        this.sendDataRefreshMsg(projectContraptionIds);
    }
}
