package com.yeejoin.amos.boot.module.jczs.api.dto;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author tb
 * @date 2021-06-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_maintenance_unit")
@ApiModel(value = "MaintenanceUnitDto", description = "MaintenanceUnitDto")
public class MaintenanceUnitDto extends BaseDto {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "统一社会信用代码")
    private String socialCreditCode;

    @ApiModelProperty(value = "维护保养单位名称")
    private String unitName;

    @ApiModelProperty(value = "省份")
    private String province;

    @ApiModelProperty(value = "地市")
    private String city;

    @ApiModelProperty(value = "区县")
    private String district;

    @ApiModelProperty(value = "区域代码")
    private String regionCode;

    @ApiModelProperty(value = "地址(详细地址，包括道路、门牌号码)")
    private String address;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "法人id")
    private Long legalPersonId;

    @ApiModelProperty(value = "法人")
    private String legalPerson;

    @ApiModelProperty(value = "法人电话/注册电话")
    private String legalPersonPhone;

    @ApiModelProperty(value = "企业资质等级")
    private String qualificationLevel;

    @ApiModelProperty(value = "信用级别")
    private Integer creditLevel;

    @ApiModelProperty(value = "许可证编号")
    private String licenseNum;

    @ApiModelProperty(value = "值班电话")
    private String dutyPhone;

    @ApiModelProperty(value = "紧急电话号码")
    private String emergencyPhone;

    @ApiModelProperty(value = "主要负责人1")
    private String principalFirst;

    @ApiModelProperty(value = "主要负责人1手机号码")
    private String principalFirstPhone;

    @ApiModelProperty(value = "主要负责人1id")
    private Long principalFirstId;

    @ApiModelProperty(value = "主要负责人2")
    private String principalSecond;

    @ApiModelProperty(value = "主要负责人2手机号码")
    private String principalSecondPhone;

    @ApiModelProperty(value = "主要负责人2id")
    private Long principalSecondId;

    @ApiModelProperty(value = "原始表id（来自历史数据库）")
    private String originalId;

    @ApiModelProperty(value = "人员信息")
    List<DutyPersonDto> dutyPersonList;
}
