package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgMaintainNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgMaintainNotice;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-12
 */
public interface JgMaintainNoticeMapper extends CustomBaseMapper<JgMaintainNotice> {
    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 维修告知列表
     */
    Page<JgMaintainNotice> queryForPage(Page<JgMaintainNotice> page,
                                        @Param("param") JgMaintainNoticeDto model,
                                        @Param("type") String type,
                                        @Param("orgCode") String orgCode,
                                        @Param("userId") String userId);

    /**
     * 根据维修告知编号查询设备、设计、制造等信息
     *
     * @param sequenceNbr 维修告知编号
     */
    @MapKey("sequenceNbr")
    List<Map<String, Object>> queryEquipInformation(@Param("sequenceNbr") long sequenceNbr);

    void updatePromoter(@Param("id")Long id);

    Map<String, Object> getEquipInfoByRecord(String record);

}
