package com.yeejoin.amos.boot.module.jg.biz.controller;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.api.dto.JgInstallationAccDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgInstallationNoticeDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgInstallationNoticeServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 安装告知
 *
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api(tags = "安装告知工作流相关Api")
@RequestMapping(value = "/jg-installation-workflow")
public class JgInstallationByWorkFlowController {


    @Autowired
    JgInstallationNoticeServiceImpl jgInstallationNoticeServiceImpl;

    /**
     * 提交
     *
     * @return
     */
    @Deprecated
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/submit")
    @ApiOperation(httpMethod = "POST", value = "安装告知提交", notes = "安装告知提交")
    public ResponseModel<JgInstallationNoticeDto> submit(@RequestBody JgInstallationNoticeDto model, String op) {
        // TODO 发起安装告知流程
        // jgInstallationNoticeServiceImpl.submit(model, op);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 撤销
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/cancel")
    @ApiOperation(httpMethod = "POST", value = "安装告知撤销", notes = "安装告知撤销")
    public ResponseModel<JgInstallationNoticeDto> cancel(@RequestBody Map<String, Object> model) {
        JgInstallationNoticeDto installationInfo = BeanUtil.mapToBean(((LinkedHashMap) model.get("installationInfo")), JgInstallationNoticeDto.class, true);
        if (Objects.isNull(installationInfo)) {
            throw new IllegalArgumentException("参数installationInfo不能为空");
        }
        jgInstallationNoticeServiceImpl.cancel(installationInfo);
        return ResponseHelper.buildResponse(installationInfo);
    }

    /**
     * 受理
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/accept")
    @ApiOperation(httpMethod = "POST", value = "安装告知受理", notes = "安装告知受理")
    public ResponseModel<JgInstallationNoticeDto> accept(@RequestBody Map<String, Object> model, String op) {
        // TODO 受理安装告知流程
        LinkedHashMap model1 = (LinkedHashMap)model.get("model");
        String opinion = (String)model.get("opinion");
        LinkedHashMap installationInfo = (LinkedHashMap)model1.get("installationInfo");
        JgInstallationNoticeDto jgInstallationNoticeDto = JSON.parseObject(JSON.toJSONString(installationInfo), JgInstallationNoticeDto.class);
        jgInstallationNoticeDto.setProcessAdvice(opinion);
        jgInstallationNoticeServiceImpl.accept(jgInstallationNoticeDto,op);
        return ResponseHelper.buildResponse(null);
    }
}
