package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author LiuLin
 */

@AllArgsConstructor
@Getter
public enum JYJCTypeEnum {

    /**
     * 检验检测类型
     */
    AQFJY("AQFJY", "安全阀校验"),
    DTJC("DTJC", "电梯检测"),
    DQJY("DQJY", "定期检验"),
    SCJY("SCJY", "首次检验"),
    WXJDJY("WXJDJY", "维修监督检验"),
    GZJDJY("GZJDJY", "改造监督检验"),
    AZJDJY("AZJDJY", "安装监督检验");

    private final String code;
    private final String name;

    public static JYJCTypeEnum of(String code) {
        for (JYJCTypeEnum e : JYJCTypeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }
}
