package com.yeejoin.amos.boot.module.common.biz.listener;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrAgencyUserService;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqxListener;

import java.nio.charset.StandardCharsets;

/**
 * @author Administrator
 */
@Component
public class AmosMqttListener extends EmqxListener {

    @Autowired
    IOrgUsrAgencyUserService orgUsrAgencyUserService;

    @Override
    public void processMessage(String topic, MqttMessage mqttMessage) throws Exception {
        byte[] payload = mqttMessage.getPayload();
        String str = new String(payload, StandardCharsets.UTF_8);
        JSONObject jsonObject = JSONObject.parseObject(str);
        JSONObject result = jsonObject.getJSONObject("result");
        String path = result.getString("path");
        if (path.contains("agencyuser")) {
            orgUsrAgencyUserService.synOrgUser(jsonObject);
        }
    }
}
