package com.yeejoin.equipmanage.service.impl;

import com.google.common.collect.Maps;
import com.yeejoin.equipmanage.common.utils.DateUtils;
import com.yeejoin.equipmanage.mapper.CarMapper;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificAlarmLogMapper;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificIndexMapper;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificMapper;
import com.yeejoin.equipmanage.service.IEquipmentInfoOnPlanService;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author keyong
 * @title: EquipmentInfoOnPlanServiceImpl
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2022/5/12 11:43
 */
@Service("EquipmentInfoOnPlanService")
public class EquipmentInfoOnPlanServiceImpl implements IEquipmentInfoOnPlanService {

    @Autowired
    private EquipmentSpecificMapper equipmentSpecificMapper;

    @Autowired
    private EquipmentSpecificAlarmLogMapper equipmentSpecificAlarmLogMapper;
    
    @Autowired 
    EquipmentSpecificIndexMapper equipmentSpecificIndexMapper;

    @Autowired
    private CarMapper carMapper;

    @Value("${equipment.plan.monitor}")
    String monitorCodes;

    @Value("${equipment.plan.pump}")
    String pumpCodes;

    @Override
    public List<Map<String, Object>> getFireMonitorInfo(Long equipmentId) {
        String[] strings = monitorCodes.split(",");
        List<Map<String, Object>> list = equipmentSpecificMapper.getFireMonitorInfo(equipmentId, strings);
        return Optional.ofNullable(list).orElse(Lists.newArrayList());
    }

    @Override
    public List<Map<String, Object>> getFirePumpInfo() {
        String[] strings = pumpCodes.split(",");
        List<Map<String, Object>> list = equipmentSpecificMapper.getFirePumpInfo(strings);
        return Optional.ofNullable(list).orElse(Lists.newArrayList());
    }

    @Override
    public List<Map<String, Object>> getOtherEquipInfo() {
        List<Map<String, Object>> list = equipmentSpecificIndexMapper.getEquipSpecificIndexByUpdateDateDesc();

        list.stream().filter(item -> item.containsKey("createDate") && !ObjectUtils.isEmpty(item.get("createDate"))).forEach(item -> {
//            try {
//                Date carStateDate = DateUtils.dateParse(item.get("createDate").toString(), "yyyy-MM-dd'T'HH:mm:ss");
//                String s = DateUtils.dateFormat(carStateDate, DateUtils.DATE_TIME_PATTERN).replaceAll("T", " ");
//                item.put("createDate", s);
//            } catch (ParseException e) {
//                e.printStackTrace();
//            }
            String s = item.get("createDate").toString().replaceAll("T", " ");
            item.put("createDate", s);


        });
        return Optional.ofNullable(list).orElse(Lists.newArrayList());
    }

    @Override
    public Map<String, Object> getFirePowerAndCarInfo() {
        List<Map<String, Object>> firePowerMap = carMapper.getFirePowerInfo();
        List<Map<String, Object>> carStateMap = carMapper.getCarState();
        Map<String, Object> map = new HashMap<>();
        map.put("firePower", Optional.ofNullable(firePowerMap).orElse(Lists.newArrayList()));
        map.put("carState", Optional.ofNullable(carStateMap).orElse(Lists.newArrayList()));
        return map;
    }
}
