package com.yeejoin.amos.boot.module.tdc.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckModel;
import com.yeejoin.amos.boot.module.tdc.api.service.CheckModelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * @author xxz
 */
@RestController
@Api(tags = "校验模型api")
@RequestMapping(value = "/model")
public class CheckModelController {

    @Autowired
    CheckModelService checkModelService;

    /**
     * 根据amosOrgCode查询
     * return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "selectByOrgCode")
    @ApiOperation(httpMethod = "GET",value = "根据amosOrgCode查询模型列表",  notes = "根据amosOrgCode查询模型列表")
    public ResponseModel<IPage<CheckModel>> selectByOrgCode(int current, int size, String amosOrgCode) {
        return ResponseHelper.buildResponse(checkModelService.selectByOrgCode(current,size,amosOrgCode));
    }

    /**
     * 根据amosOrgCode查询
     * return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "selectOneByDate")
    @ApiOperation(httpMethod = "GET",value = "根据code查询最后一次校验模型",  notes = "查询code最后一次校验模型")
    public ResponseModel<CheckModel> selectOneByDate(String amosOrgCode) {
        return ResponseHelper.buildResponse(checkModelService.selectOneByDate(amosOrgCode));
    }

}
