package com.yeejoin.amos.boot.module.tdc.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tdc.api.dto.CheckResultDto;
import com.yeejoin.amos.boot.module.tdc.api.dto.ModelTreeDto;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckResult;
import com.yeejoin.amos.boot.module.tdc.api.service.CheckResultService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;


/**
 * 校验结果
 * @author xxz
 */
@RestController
@Api(tags = "校验结果Api")
@RequestMapping(value = "/check-result")
public class CheckResultController extends BaseController {

    @Autowired
    CheckResultService checkResultService;

    /**
     * cs
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectResult")
    @ApiOperation(httpMethod = "GET", value = "result", notes = "result")
    public ResponseModel<IPage<CheckResultDto>> selectResult(int current,int size,String code) {
        return ResponseHelper.buildResponse(checkResultService.selectResult(current, size, code));
    }

    /**
     * 根据amosOrgCode、modelId查询不合格项
     * return
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectCheckResult")
    @ApiOperation(httpMethod = "GET",value = "查询最后一次校验模型",  notes = "查询最后一次校验模型")
    public ResponseModel<List<CheckResult>> selectCheckResult( String modelId, String amosOrgCode) {
        return ResponseHelper.buildResponse(checkResultService.selectCheckResult(modelId,amosOrgCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectTotal")
    @ApiOperation(httpMethod = "GET", value = "result", notes = "result")
    public ResponseModel<List<CheckResultDto>> selectTotal(String modelId, String amosOrgCode) {
        return ResponseHelper.buildResponse(checkResultService.selectTotal(modelId, amosOrgCode));
    }

    /**
     * 根据amosOrgCode、modelId查询不合格项
     * return
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectCheckResult/test")
    @ApiOperation(httpMethod = "GET",value = "查询最后一次校验模型",  notes = "查询最后一次校验模型")
    public ResponseModel<List<ModelTreeDto>> test() {
        return ResponseHelper.buildResponse(checkResultService.test());
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectCheckResult/TreeTwo")
    @ApiOperation(httpMethod = "GET",value = "查询最后一次校验模型",  notes = "查询最后一次校验模型")
    public ResponseModel<ModelTreeDto> treeTwo(String tableId) {


        return ResponseHelper.buildResponse(checkResultService.treeTwo(tableId));
    }


    /**
     * cs
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectDetails/")
    @ApiOperation(httpMethod = "GET", value = "result", notes = "result")
    public ResponseModel<List<CheckResultDto>> selectDetails( String batchNo,int modelId) {
        return ResponseHelper.buildResponse(checkResultService.selectDetails(batchNo,modelId));
    }

    /**
     * cs
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/select")
    @ApiOperation(httpMethod = "GET", value = "result", notes = "result")
    public ResponseModel<String> select(String amosOrgCode) {
        return ResponseHelper.buildResponse(checkResultService.select(amosOrgCode));
    }


}
