package com.yeejoin.amos.boot.module.tdc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckModel;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckReport;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckResult;
import com.yeejoin.amos.boot.module.tdc.api.mapper.CheckModelMapper;
import com.yeejoin.amos.boot.module.tdc.api.service.CheckModelService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

/**
 * @author xxz
 */
@Service
public class CheckModelImpl extends ServiceImpl<CheckModelMapper, CheckModel> implements CheckModelService {

    @Override
    public IPage<CheckModel> selectByOrgCode(int current, int size, String amosOrgCode) {
        Page page = new Page(current,size);

        if(ValidationUtil.isEmpty(amosOrgCode)){
            return this.page(page);

        }else{
            LambdaQueryWrapper<CheckModel> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(CheckModel::getAmosOrgCode, amosOrgCode);
//        return baseMapper.selectList(wrapper);
            return this.page(page,wrapper);
        }

    }

    @Override
    public CheckModel selectOneByDate(String amosOrgCode) {
        LambdaQueryWrapper<CheckModel> wrapper = new LambdaQueryWrapper<>();
        wrapper
                .eq(CheckModel::getAmosOrgCode, amosOrgCode)
                .isNotNull(CheckModel::getCheckDate)
                .orderByDesc(CheckModel::getCheckDate)
                .last("limit 1");
        return baseMapper.selectOne(wrapper);
    }
}

