package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.yeejoin.amos.boot.module.jg.api.entity.JgCertificateReplenishEq;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.List;

import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgCertificateReplenishEqServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * @author system_generator
 * @date 2025-03-19
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/jg-certificate-replenish-eq")
public class JgCertificateReplenishEqController extends BaseController {

    @Autowired
    JgCertificateReplenishEqServiceImpl jgCertificateReplenishEqServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<JgCertificateReplenishEq> save(@RequestBody JgCertificateReplenishEq entity) {
        entity = jgCertificateReplenishEqServiceImpl.createWithModel(entity);
        return ResponseHelper.buildResponse(entity);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<JgCertificateReplenishEq> updateBySequenceNbrJgCertificateReplenishEq(@RequestBody JgCertificateReplenishEq entity, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        entity.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(jgCertificateReplenishEqServiceImpl.updateWithModel(entity));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgCertificateReplenishEqServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<JgCertificateReplenishEq> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgCertificateReplenishEqServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<JgCertificateReplenishEq>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<JgCertificateReplenishEq> page = new Page<JgCertificateReplenishEq>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(jgCertificateReplenishEqServiceImpl.queryForJgCertificateReplenishEqPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<JgCertificateReplenishEq>> selectForList() {
        return ResponseHelper.buildResponse(jgCertificateReplenishEqServiceImpl.queryForJgCertificateReplenishEqList());
    }
}
