package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.dto.FireRiskSourceDto;
import com.yeejoin.equipmanage.common.request.Common3dRequest;
import com.yeejoin.equipmanage.common.response.Common3dResponse;
import com.yeejoin.equipmanage.common.response.Common3dResponseUtil;
import com.yeejoin.equipmanage.common.vo.Request3dVo;
import com.yeejoin.equipmanage.service.IRiskSourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;

/**
 * @ProjectName: EquipManageRoot
 * @Package: com.yeejoin.equipmanage..controller
 * @ClassName: FireRiskSource
 * @Author: Jianqiang Gao
 * @Description: FireRiskSource
 * @Date: 2021/08/30 09:58
 * @Version: 1.0
 */
@Api(tags = "风险区域")
@RestController
@RequestMapping("/riskSource")
public class RiskSourceController extends AbstractBaseController {

    @Autowired
    private IRiskSourceService riskSourceService;

    /**
     * 获取指定层级风险区域树，起步2级树
     *
     * @param request，统一请求参数对象，传递是否风险区域，不传递，所有树
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation("获取指定风险区域层级树")
    @PostMapping(value = "/getFiskSourceTierTree")
    public Common3dResponse getFiskSourceTierTree(@RequestBody(required = false) Common3dRequest request) {
        Integer tier = null;
        Boolean isRegion = null;
        if (request != null) {
            Request3dVo body = request.getBody();
            tier = body.getInteger();
            isRegion = body.getBool();
        }
        List<FireRiskSourceDto> list = riskSourceService.getFiskSourceTierTree(tier, isRegion);
        return Common3dResponseUtil.success(list);
    }

}
