package com.yeejoin.amos.boot.module.ugp.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @Author cpp
 * @Description  智能监检列表
 * @Date 2022/10/19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="SmartListDto", description="智能监检列表")
public class SmartListDto extends BaseDto {

    @ApiModelProperty(value = "项目id")
    private Long projectId;
    @ApiModelProperty(value = "项目名称")
    private String name;

    @ApiModelProperty(value = "项目编号")
    private String projectCode;

    @ApiModelProperty(value = "检验检测单位")
    private String companyName;

    @ApiModelProperty(value = "检验负责人")
    private String usrName;

    @ApiModelProperty(value = "检验员")
    private String inspector;

    @ApiModelProperty(value = "检验状态")
    private String status;

    @ApiModelProperty(value = "检验方式")
    private String type;

    @ApiModelProperty(value = "交检日期")
    private Date submitTime;

    @ApiModelProperty(value = "检验时间")
    private Date verifyTime;

    //管材
    @ApiModelProperty(value = "焊口编号")
    private String code;
    @ApiModelProperty(value = "管材厂家")
    private String manufacturer;
    @ApiModelProperty(value = "管材批号")
    private String batchNumber;
    @ApiModelProperty(value = "质量许可")
    private String permission;
    @ApiModelProperty(value = "焊工编号")
    private String personWeld;

    //设备
    @ApiModelProperty(value = "焊机编号")
    private String facilityNumber;
    @ApiModelProperty(value = "焊机名称")
    private String facilityName;
    @ApiModelProperty(value = "检定状态")
    private String facilityStatus;



    //人员
    @ApiModelProperty(value = "焊工姓名")
    private String peopleName;
    @ApiModelProperty(value = "持证状态")
    private String peopleStatus;
    @ApiModelProperty(value = "定位信息")
    private String peopleLocation;

     // 工艺
     @ApiModelProperty(value = "焊接工艺")
     private String craft;

    @ApiModelProperty(value = "焊接时长")
    private String duration;

    //耐压
    @ApiModelProperty(value = "耐压测试编号")
    private String pressureNumber;
    @ApiModelProperty(value = "耐压设备名称")
    private String pressureName;
    @ApiModelProperty(value = "耐压设备编码")
    private String pressureCode;
    @ApiModelProperty(value = "测试压力Mpa")
    private String mpa;

    //定位检验
    @ApiModelProperty(value = "焊口精确定位方式")
    private String preciseWeldingPosition;
    @ApiModelProperty(value = "位置标定检验结果")
    private String resuts;
   //埋深
   @ApiModelProperty(value = "埋深检测方式")
   private String detectionMethod;
    @ApiModelProperty(value = "埋深m")
    private String burialDepth;


    @ApiModelProperty(value = "检验检测阶段")
    private String stage;





}
