package com.yeejoin.amos.boot.module.ugp.api.entity;

import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
/**
 * 监检任务表
 *
 * @author duanwei
 * @date 2022-10-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="TzUgpTask对象", description="监检任务表")
public class Task extends BaseEntity {

    private static final long serialVersionUID = 1L;





    @ApiModelProperty(value = "任务名称")
    private String name;

    @ApiModelProperty(value = "焊工id")
    private String welderId;

    @ApiModelProperty(value = "任务状态（0：未开始 1：进行中 2：已结束）")
    private String status;

    @ApiModelProperty(value = "任务开始时间")
    private Date startTime;

    @ApiModelProperty(value = "任务结束时间")
    private Date overTime;


    @ApiModelProperty(value = "项目id")
    private Long projectId;


}
