package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.RectifyMsgServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.RectifyMsgDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 整改短信通知表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "整改短信通知表Api")
@RequestMapping(value = "/rectify-msg")
public class RectifyMsgController extends BaseController {

    @Autowired
    RectifyMsgServiceImpl rectifyMsgServiceImpl;

    /**
     * 新增整改短信通知表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增整改短信通知表", notes = "新增整改短信通知表")
	public ResponseModel<RectifyMsgDto> save(@RequestBody RectifyMsgDto model) {
	    model = rectifyMsgServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新整改短信通知表", notes = "根据sequenceNbr更新整改短信通知表")
	public ResponseModel<RectifyMsgDto> updateBySequenceNbrRectifyMsg(@RequestBody RectifyMsgDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(rectifyMsgServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除整改短信通知表", notes = "根据sequenceNbr删除整改短信通知表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(rectifyMsgServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个整改短信通知表",  notes = "根据sequenceNbr查询单个整改短信通知表")
	public ResponseModel<RectifyMsgDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(rectifyMsgServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "整改短信通知表分页查询",  notes = "整改短信通知表分页查询")
	public ResponseModel<IPage<RectifyMsgDto>> queryForPage(
			@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size,
			@RequestParam(value = "name",required = false) String name,
			@RequestParam(value = "installationUnit",required = false) String installationUnit) {
	    IPage<RectifyMsgDto> page = new Page<RectifyMsgDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(rectifyMsgServiceImpl.queryForRectifyMsgPage(page,name,installationUnit));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "整改短信通知表列表全部数据查询",   notes = "整改短信通知表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<RectifyMsgDto>> selectForList() {
	    return ResponseHelper.buildResponse(rectifyMsgServiceImpl.queryForRectifyMsgList());
	}
}
