package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.ugp.api.Enum.StageEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.*;
import com.yeejoin.amos.boot.module.ugp.api.entity.Verify;
import com.yeejoin.amos.boot.module.ugp.api.service.IVerifyService;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.ugp.biz.service.impl.VerifyServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 智能监检管理表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "智能监检管理表Api")
@RequestMapping(value = "/verify")
public class VerifyController extends BaseController {

	@Autowired
	VerifyServiceImpl verifyServiceImpl;
	@Autowired
	IVerifyService service;

	/**
	 * 新增智能监检管理表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增智能监检管理表", notes = "新增智能监检管理表")
	public ResponseModel<VerifyDto> save(@RequestBody VerifyDto model) {
		model = verifyServiceImpl.createWithModel(model);
		return ResponseHelper.buildResponse(model);
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新智能监检管理表", notes = "根据sequenceNbr更新智能监检管理表")
	public ResponseModel<VerifyDto> updateBySequenceNbrVerify(@RequestBody VerifyDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setSequenceNbr(sequenceNbr);
		return ResponseHelper.buildResponse(verifyServiceImpl.updateWithModel(model));
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除智能监检管理表", notes = "根据sequenceNbr删除智能监检管理表")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(verifyServiceImpl.removeById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个智能监检管理表", notes = "根据sequenceNbr查询单个智能监检管理表")
	public ResponseModel<VerifyDto> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(verifyServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "智能监检管理表分页查询", notes = "智能监检管理表分页查询")
	public ResponseModel<Page<VerifyDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size) {
		Page<VerifyDto> page = new Page<VerifyDto>( );
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(verifyServiceImpl.queryForVerifyPage(page));
	}

	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "智能监检管理表列表全部数据查询", notes = "智能监检管理表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<VerifyDto>> selectForList() {
		return ResponseHelper.buildResponse(verifyServiceImpl.queryForVerifyList( ));
	}
	/**
	 * cpp
	 * <p>
	 * 焊接管材检验信息列表
	 *
	 * @param current
	 * @param size
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectTubular")
	@ApiOperation(httpMethod = "GET", value = "焊接管材检验信息列表", notes = "焊接管材检验信息列表")
	public ResponseModel<Page<SmartListDto>> selectTubular(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>( );
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.焊前管材质量.getStage( ), page, smartListDto));
	}

	/**
	 * cpp
	 * <p>
	 * 查询焊接人员检验信息列表
	 *
	 * @param current
	 * @param size
	 * @param
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectWorker")
	@ApiOperation(httpMethod = "GET", value = "查询焊接人员检验信息列表", notes = "查询焊接人员检验信息列表")
	public ResponseModel<Page<SmartListDto>> selectWorker(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>( );
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.焊前人员.getStage( ), page, smartListDto));
	}

	/**
	 * cpp
	 * <p>
	 * 查询焊接设备检验信息列表
	 *
	 * @param current
	 * @param size
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectFacility")
	@ApiOperation(httpMethod = "GET", value = "查询焊接设备检验信息列表", notes = "查询焊接设备检验信息列表")
	public ResponseModel<Page<SmartListDto>> selectFacility(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>( );
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.焊前设备.getStage( ), page, smartListDto));
	}

	/**
	 * cpp
	 * <p>
	 * 查询焊接工艺检验信息列表
	 *
	 * @param current
	 * @param size
	 * @return
	 */

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectCraft")
	@ApiOperation(httpMethod = "GET", value = "查询焊接工艺检验信息列表", notes = "查询焊接工艺检验信息列表")
	public ResponseModel<Page<SmartListDto>> selectCraft(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>( );
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.焊接工艺.getStage( ), page, smartListDto));
	}

	/**
	 * cpp
	 * <p>
	 * 查询管道耐压检验信息列表
	 *
	 * @param current
	 * @param size
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectVoltage")
	@ApiOperation(httpMethod = "GET", value = "查询管道耐压检验信息列表", notes = "查询管道耐压检验信息列表")
	public ResponseModel<Page<SmartListDto>> selectVoltage(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>( );
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.管道耐压.getStage( ), page, smartListDto));
	}

	/**
	 * 敷设质量
	 *
	 * @param current
	 * @param size
	 * @param smartListDto
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/depth")
	@ApiOperation(httpMethod = "GET", value = "敷设质量", notes = "敷设质量")
	public ResponseModel<Page<SmartListDto>> depth(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>( );
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.敷设质量.getStage( ), page, smartListDto));
	}

	/**
	 * cpp
	 * <p>
	 * 位置标定检验列表
	 *
	 * @param current
	 * @param size
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/selectLocation")
	@ApiOperation(httpMethod = "GET", value = "敷设位置标定检验列表", notes = "敷设位置标定检验列表")
	public ResponseModel<Page<SmartListDto>> selectLocation(@RequestParam(value = "current") int current, @RequestParam
			(value = "size") int size, SmartListDto smartListDto) {
		Page<SmartListDto> page = new Page<>( );
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(service.commonality(StageEnum.定位.getStage( ), page, smartListDto));
	}

	/**
	 * cpp
	 * 校验
	 *
	 * @param jsonObject
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@PostMapping(value = "/checks")
	@ApiOperation(httpMethod = "POST", value = "校验app上传数据", notes = "校验app上传数据")
	public ResponseModel<String> checks(@RequestBody JSONObject jsonObject) {
		return ResponseHelper.buildResponse(verifyServiceImpl.checks(jsonObject));
	}

	/**
	 * cpp
	 * 主键id查询verity表
	 *
	 * @param
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/selectById")
	@ApiOperation(httpMethod = "GET", value = "主键id查询verity表", notes = "主键id查询verity表")
	public ResponseModel<OpenDto> selectById(@RequestParam Long sequenceNbr) {
		return ResponseHelper.buildResponse(verifyServiceImpl.selectById(sequenceNbr));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/photo")
	@ApiOperation(httpMethod = "GET", value = "获取图片", notes = "获取图片")
	public ResponseModel<Map> photo(@RequestParam Long sequenceNbr) {
		Map map = new HashMap<>( );
		map.put("newPhoto", "https://img2.baidu.com/it/u=806791452,2765805606&fm=253&fmt=auto&app=138&f=JPEG?w=350&h=500");
		return ResponseHelper.buildResponse(map);
	}

}

















