package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.ugp.api.entity.Attachment;
import com.yeejoin.amos.boot.module.ugp.api.mapper.AttachmentMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IAttachmentService;
import com.yeejoin.amos.boot.module.ugp.api.dto.AttachmentDto;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 附件表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class AttachmentServiceImpl extends BaseService<AttachmentDto,Attachment,AttachmentMapper> implements IAttachmentService {
    /**
     * 分页查询
     */
    public Page<AttachmentDto> queryForAttachmentPage(Page<AttachmentDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<AttachmentDto> queryForAttachmentList()   {
        return this.queryForList("" , false);
    }

    /**
     * 根据sourceId添加附件
     * @param subForm
     * @param sequenceNbr
     *
     */
    public void saveAttachment(JSONArray subForm, Long sequenceNbr){
        Attachment attachment = new Attachment();
        attachment.setSourceId(sequenceNbr);
        attachment.setInfo(JSON.toJSONString(subForm));
        for(Object o:subForm){
            JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(o));
            jsonObject.getString("Symbol_key");
            JSONArray jsonArray = jsonObject.getJSONArray("info");
            if(!ValidationUtil.isEmpty(jsonArray)) {
                for (Object j : jsonArray) {
                    JSONObject info = JSON.parseObject(JSON.toJSONString(j));
                    String name = info.getString("name");
                    attachment.setName(info.getString("name"));
                    attachment.setType(name.substring(name.lastIndexOf(".") + 1));
                    break;
                }
            }
        }
        this.save(attachment);
    }
}