package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticePageDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.InstallNotice;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.mapper.InstallNoticeMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IInstallNoticeService;
import com.yeejoin.amos.boot.module.ugp.api.dto.InstallNoticeDto;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.sql.Wrapper;
import java.util.*;

/**
 * 安装告知表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class InstallNoticeServiceImpl extends BaseService<InstallNoticeDto,InstallNotice,InstallNoticeMapper> implements IInstallNoticeService{

    @Autowired
    InstallNoticeMapper installNoticeMapper;
    @Autowired
    ProjectServiceImpl projectServiceImpl;
    @Autowired
    ProjectInitiationServiceImpl projectInitiationServiceImpl;
    @Autowired
    OrgServiceImpl orgServiceImpl;
    @Autowired
    ProjectResourceServiceImpl projectResourceServiceImpl;
    /**
     * 分页查询
     */
    public Page<InstallNoticeDto> queryForInstallNoticePage(Page<InstallNoticeDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<InstallNoticeDto> queryForInstallNoticeList()   {
        return this.queryForList("" , false);
    }

    /**
     * 安装告知申请分页查询
     */
    public Page<InstallNoticePageDto> installNoticePage(Page<InstallNoticePageDto> page,String name,String constructionUnit)   {
        List<Project> projectList = projectResourceServiceImpl.getProjectList();
        Set<String> ids = new HashSet<>();
        for(Project project : projectList){
            String id = String.valueOf(project.getSequenceNbr());
            ids.add(id);
        }
        Page<InstallNoticePageDto> installNoticePage = installNoticeMapper.installNoticePage(page,name,constructionUnit,ids);
        List<InstallNoticePageDto> installNoticePageDtos = installNoticePage.getRecords();
        for(InstallNoticePageDto installNoticePageDto:installNoticePageDtos){
            if(!ValidationUtil.isEmpty(installNoticePageDto.getApproved())){
                if(installNoticePageDto.getApproved()){
                    installNoticePageDto.setApprovedName("通过");
                }else{
                    installNoticePageDto.setApprovedName("不通过");
                }
            }
        }
        return installNoticePage;
    }

    /**
     * 根据sequenceNbr查询告知申请详情
     * @param sequenceNbr
     * @return
     */
    public InstallNoticeDto selectOneById(Long sequenceNbr){
        return installNoticeMapper.selectoneById(sequenceNbr);
    }

    /**
     * 新增安装告知申请,保存/提交
     *
     * @return
     */
     public InstallNoticeDto saveInstallNotice(JSONObject object, String noticeStatus ) {

        InstallNoticeDto installNoticeDto = new InstallNoticeDto();
		final ProjectDto projectDto = projectServiceImpl.queryBySeq(object.getLong("name"));
        installNoticeDto.setProjectId(object.getLong("name"));
        installNoticeDto.setProjectName(projectDto.getName());
        installNoticeDto.setCompanyName(projectDto.getInstallationUnit());
        installNoticeDto.setNoticeStatus(noticeStatus);
        installNoticeDto.setNoticeDate(new Date());
        installNoticeDto.setApproved(false);
        installNoticeDto.setInstallPri(object.getString("installPri"));
		installNoticeDto.setOrganizationCode(orgServiceImpl.getOrgUsr().getBizOrgCode());
        installNoticeDto.setLicenseNum(object.getString("licenseNum"));
        installNoticeDto.setLicenseCompany(object.getString("licenseCompany"));
        final JSONArray licenseAttch = object.getJSONArray("licenseAttch");
        final JSONArray contractAttch = object.getJSONArray("contractAttch");
        installNoticeDto.setLicenseAttch(JSON.toJSONString(licenseAttch));
        installNoticeDto.setContractAttch(JSON.toJSONString(contractAttch));
        installNoticeDto.setOrganizationCode(orgServiceImpl.getOrgUsr().getBizOrgCode());
        installNoticeDto = this.createWithModel(installNoticeDto);
		projectInitiationServiceImpl.execute(projectDto.getInstanceId(),installNoticeDto,"1");
        return  installNoticeDto;
    }

    /**
     * 根据sequenceNbr查询安装告知信息及附件
     *
     * @param sequenceNbr  主键
     * @return
     */
    public JSONObject selectOneBySeq(Long sequenceNbr) {
        final InstallNoticeDto installNoticeDto = selectOneById(sequenceNbr);
        final ProjectDto projectDto = projectServiceImpl.queryBySeq(installNoticeDto.getProjectId());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name",projectDto.getName());
        jsonObject.put("installRegion",projectDto.getInstallRegion());
        jsonObject.put("licenseNum",installNoticeDto.getLicenseNum());
        jsonObject.put("licenseCompany",installNoticeDto.getLicenseCompany());
        jsonObject.put("licenseAttch",JSON.parseArray(installNoticeDto.getLicenseAttch()));
        jsonObject.put("contractAttch",JSON.parseArray(installNoticeDto.getContractAttch()));
        jsonObject.put("installPri",installNoticeDto.getInstallPri());
        return jsonObject;
    }
}