package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.ugp.api.entity.SuperviseRule;
import com.yeejoin.amos.boot.module.ugp.api.mapper.SuperviseRuleMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.ISuperviseRuleService;
import com.yeejoin.amos.boot.module.ugp.api.dto.SuperviseRuleDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.ArrayList;
import java.util.List;

/**
 * 监管区域规则表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class SuperviseRuleServiceImpl extends BaseService<SuperviseRuleDto,SuperviseRule,SuperviseRuleMapper> implements ISuperviseRuleService {

    @Autowired
    OrgServiceImpl orgServiceImpl;
    /**
     * 分页查询
     */
    public IPage<SuperviseRuleDto> queryForSuperviseRulePage(IPage page, SuperviseRule superviseRule) {

        Integer adminRegionCode = superviseRule.getAdminRegionCode();

        Long superviseDeptId = superviseRule.getSuperviseDeptId();
        Long inspectionUnitId = superviseRule.getInspectionUnitId();
        LambdaQueryWrapper<SuperviseRule> wrapper = new LambdaQueryWrapper<>();
        if(ValidationUtil.isEmpty(adminRegionCode)){
            return null;
        }else {
//        if(!ValidationUtil.isEmpty(adminRegionCode)){
//            wrapper.eq(SuperviseRule::getAdminRegionCode, adminRegionCode);
//        }
            wrapper.eq(SuperviseRule::getAdminRegionCode, adminRegionCode);
        }
            if (!ValidationUtil.isEmpty(superviseDeptId)) {
                wrapper.like(SuperviseRule::getSuperviseDeptId, superviseDeptId);
            }
            if (!ValidationUtil.isEmpty(inspectionUnitId)) {
                wrapper.like(SuperviseRule::getInspectionUnitId, inspectionUnitId);
            }
            page = this.page(page, wrapper);
            List<SuperviseRule> superviseRuleList = page.getRecords();
            List<SuperviseRuleDto> superviseRuleDtoList = new ArrayList<>();
            for (SuperviseRule rule : superviseRuleList) {
                SuperviseRuleDto superviseRuleDto = new SuperviseRuleDto();
                BeanUtils.copyProperties(rule, superviseRuleDto);
                superviseRuleDto.setSuperviseDept(orgServiceImpl.getOrgUsrById(String.valueOf(rule.getSuperviseDeptId())).getBizOrgName());
                superviseRuleDto.setInspectionUnit(orgServiceImpl.getOrgUsrById(String.valueOf(rule.getInspectionUnitId())).getBizOrgName());
                superviseRuleDto.setCreateUnit(orgServiceImpl.getOrgUsrById(String.valueOf(rule.getCreateUnitId())).getBizOrgName());
                superviseRuleDtoList.add(superviseRuleDto);
            }
            page.setRecords(superviseRuleDtoList);
            return page;

    }

    /**
     * 列表查询 示例
     */
    public List<SuperviseRuleDto> queryForSuperviseRuleList()   {
        return this.queryForList("" , false);
    }
}