package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import com.alibaba.fastjson.serializer.SerializerFeature;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.mao.expertSystem.WeldingQualification;
import com.mao.expertSystem.material.MyPqr;
import com.mao.expertSystem.material.MyWps;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;

import com.yeejoin.amos.boot.module.ugp.api.Enum.StageEnum;

import com.yeejoin.amos.boot.module.ugp.api.Enum.VerifyEnum;

import com.yeejoin.amos.boot.module.ugp.api.Enum.VerifyTypeEnum;

import com.yeejoin.amos.boot.module.ugp.api.constants.XJConstant;
import com.yeejoin.amos.boot.module.ugp.api.dto.*;

import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.QualityProblem;

import com.yeejoin.amos.boot.module.ugp.api.entity.Verify;

import com.yeejoin.amos.boot.module.ugp.api.entity.Weld;

import com.yeejoin.amos.boot.module.ugp.api.mapper.VerifyMapper;

import com.yeejoin.amos.boot.module.ugp.api.mapper.WeldMapper;

import com.yeejoin.amos.boot.module.ugp.api.service.IVerifyService;

import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import org.apache.commons.lang.StringUtils;

import org.springframework.beans.factory.annotation.Autowired;

import org.typroject.tyboot.core.rdbms.service.BaseService;

import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;

import java.awt.*;
import java.util.*;

import java.util.List;
import java.util.stream.Collectors;



/**

 * 智能监检管理表服务实现类

 *

 * @author system_generator

 * @date 2022-09-22

 */

@Service

public class VerifyServiceImpl extends BaseService<VerifyDto,Verify,VerifyMapper> implements IVerifyService {

    @Autowired

    InstallNoticeServiceImpl installNoticeService;

    @Autowired

    WeldServiceImpl weldService;

    @Autowired

    WeldMapper weldMapper;

    @Autowired

    OrgServiceImpl orgService;


   @Autowired
   private  MaterialServiceImpl materialService;
    @Autowired

    VerifyMapper verifyMapper;
     @Autowired
     private EquipmentServiceImpl equipmentService;
    @Autowired

    QualityProblemServiceImpl qualityProblemService;
    @Autowired
    ProjectServiceImpl projectServiceImpl;

    /**

     * 分页查询

     */

    public Page<VerifyDto> queryForVerifyPage(Page<VerifyDto> page)   {

        return this.queryForPage(page, null, false);

    }

    /**
     * 列表查询 示例
     */
    public List<VerifyDto> queryForVerifyList()   {
        return this.queryForList("" , false);
    }
    /**  cpp
     * 智能监检共用查询方法
     * stage 阶段
     * page 分页
     */
    private static final String HEGE ="合格期内";
    private static final String NOTHEGE ="超期未检";
    public Page<SmartListDto> commonality(String stage,Page<SmartListDto> page,SmartListDto smartListDto){
        List<Verify> verifyList = verifyMapper.commonality(stage,smartListDto);
        List<SmartListDto> dtoList =new ArrayList<>();
        //进入焊前
        if (verifyList !=null && verifyList.size() !=0){
            for (Verify verify : verifyList) {
                SmartListDto dto = new SmartListDto( );
                dto.setSequenceNbr(verify.getSequenceNbr());//智能监检表id
                dto.setProjectId(verify.getProjectId());  //项目id
                dto.setName(verify.getProject().getName());//项目名称
                dto.setProjectCode(verify.getProject().getCode());//项目编号
                //检验状态
                String status = verify.getStatus( );
                if (status.equals(VerifyEnum.已通过.getStatus())) {
                    dto.setStatus(VerifyEnum.已通过.getName());
                }
                if (status.equals(VerifyEnum.未通过.getStatus())) {
                    dto.setStatus(VerifyEnum.未通过.getName());
                }
                dto.setType(verify.getType());//检验方式
                dto.setSubmitTime(verify.getVerifyTime());//交检日期
                dto.setVerifyTime(verify.getVerifyTime());//检验时间
                String stage1 = verify.getStage( );//检验检测阶段
                Map<String, String> map = StageEnum.getStatusByVerifyNameMap;
                for (String key:map.keySet()){
                    if (key.equals(stage1)) {
                        dto.setStage(map.get(key).toString());//将阶段赋值
                    }
                }
                String targetInfo = verify.getTargetInfo();//app上传数据
                JSONObject jsonObject = JSONObject.parseObject(targetInfo);
                String code = jsonObject.getString("code");//焊口编码
                String manyCode = jsonObject.getString("manyCode");
                if (!StringUtils.isEmpty(code)) {
                    dto.setCode(code);
                }
                if (!StringUtils.isEmpty(manyCode)) {
                    dto.setCode(manyCode);
                }
                String location = jsonObject.getString("location");
                if (!StringUtils.isEmpty(location)) {
                    dto.setPeopleLocation(location);
                }

                Long welderId = jsonObject.getLong("welderId");
                if (welderId!=null) {
                    OrgUsr orgUsr = orgService.getOrgUsrById(welderId.toString());
                    if (orgUsr != null) {
                        if (!StringUtils.isEmpty(orgUsr.getBizOrgName())) {
                            dto.setPeopleName(orgUsr.getBizOrgName());//焊工姓名
                        }
                        if (!StringUtils.isEmpty(orgUsr.getCode())) {
                            dto.setPersonWeld(orgUsr.getCode());//焊工编号
                        }
                    }
                }
                //持证判断(写死)
                dto.setPeopleStatus("合格期内");
               dto.setFacilityStatus("合格期内");
               dto.setCompanyName("检测单位");
               dto.setUsrName("检验负责人");
               dto.setInspector("cs");
               dto.setFacilityNumber("XH007");
               dto.setFacilityName("焊机xxx");
               dto.setDuration("6");
               dto.setPressureNumber("1xm001");
                 dto.setPressureName("耐压设备");
                 dto.setPressureCode("DF988x");
                Long weldingId = jsonObject.getLong("weldingId");
                if (weldingId !=null) {
                    EquipmentDto equipmentDto = equipmentService.queryBySeq(weldingId);
                    if (equipmentDto != null) {
                        //设备名  设备编号
                        dto.setFacilityName(equipmentDto.getName());
                        dto.setFacilityNumber(equipmentDto.getCode());
                    }
                }

                Long materialId = jsonObject.getLong("materialId");
                if (materialId!=null) {
                    MaterialDto materialDto = materialService.queryBySeq(materialId);
                    if (materialDto != null) {
                        //管材厂家 生产编号
                        dto.setManufacturer(materialDto.getManufacturer());
                        dto.setBatchNumber(materialDto.getBatchNum());
                        //生产日期需要判断(加判断)是否在有效期内
                        Date manufactureDate = materialDto.getManufactureDate( );
                        //将判断结果
                        dto.setPermission(HEGE);
                    }
                }

                String craft = jsonObject.getString("craft");
                if (!StringUtils.isEmpty(craft)) {
                    dto.setCraft(craft);
                }
                //耐压
                Long pressureId = jsonObject.getLong("pressureId");
                if (pressureId != null) {
                    EquipmentDto equipmentDto = equipmentService.queryBySeq(pressureId);
                    if (equipmentDto != null && !StringUtils.isEmpty(equipmentDto.getName()) &&!StringUtils.isEmpty(equipmentDto.getCode())) {
                        dto.setPressureName(equipmentDto.getName());
                        dto.setPressureCode(equipmentDto.getCode());
                    }
                }
                String pressureTest = jsonObject.getString("pressureTest");
                if (!StringUtils.isEmpty(pressureTest)) {
                    dto.setMpa(pressureTest);
                }
                //埋深
                String depthType = jsonObject.getString("depthType");
                if (!StringUtils.isEmpty(depthType)) {
                    dto.setDetectionMethod(depthType);
                }
                String depth = jsonObject.getString("depth");
                if (!StringUtils.isEmpty(depth)) {
                    dto.setBurialDepth(depth);
                }
                //位置标定
                String locationType = jsonObject.getString("locationType");
                if (!StringUtils.isEmpty(locationType)) {
                    dto.setPreciseWeldingPosition(locationType);
                }

                // //判断标定检验结果 (写死)  getResuts
                dto.setResuts("合格");


                dtoList.add(dto);

            }
        }
        page.setRecords(dtoList);
        page.setTotal(dtoList.size());

        return page ;
    }



    /**  cpp
     * 智能监检校验数据
     * @param jsonObject
     * @return String
     */
    private static final String TYPE="智能检验";

    @BusinessIdentify
    public String checks(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.size() ==0) {
            return  VerifyEnum.未通过.getName();
        }
        //通过userid和projectId来对应
        Long welderId = orgService.getReginParams( ).getBusinessInfo( ).getUserSequenceNbr( );
        Long random = jsonObject.getLong("random");//随机值
        Long projectId= jsonObject.getLong("projectId");//项目id
        //假数据Long welderId = jsonObject.getLong("welderId"); //焊工id
        String location = jsonObject.getString("location");//焊接定位信息
        String stage = jsonObject.getString("stage");//阶段检验
        Date time = new Date();// //获取当前校验时间
        String photo = jsonObject.getString("photo");//图片
        Verify verify = new Verify( );
        jsonObject.put("welderId",welderId);
        //属性赋值
        String targetInfo = jsonObject.toString();
        verify.setTargetInfo(targetInfo);//json信息
        verify.setProjectId(projectId);//项目id
        verify.setType(TYPE);//检验方式
        verify.setVerifyTime(time);//获取当前时间
     List<Verify>  verifyList = verifyMapper.selectByWelder(projectId,welderId,null,null,random);/**这里json*/
        //人员
        if (stage.equals(StageEnum.焊前人员.getVerifyName())) {
            verify.setStage(StageEnum.焊前人员.getStage()); //阶段
            /**写死*/
            Boolean flag =true;
            //1.人脸识别校验
            //2.焊工资质有效期判断,查询焊工信息获取
            //失败
            if (!flag) {
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //成功
            this.addSuccessData(verify,null,jsonObject);
        }
        //管材
        if (stage.equals(StageEnum.焊前管材质量.getVerifyName())){

            //管材未校验,进行效验步骤
            Long materialId = jsonObject.getLong("materialId");//管材id
            verify.setStage(StageEnum.焊前管材质量.getStage());
            /**校验*/
            Boolean flag = true;
            if (!flag) {
                //不通过, 添加数据并返回未通过结果
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //校验通过
            this.addSuccessData(verify,null,jsonObject);
        }
        //设备
        if (stage.equals(StageEnum.焊前设备.getVerifyName())){

            verify.setStage(StageEnum.焊前设备.getStage());
            /**
             * 效验假数据
             */
            Boolean flag =true ;

            if (!flag) {
                //校验不通过
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            this.addSuccessData(verify,null,jsonObject);
        }
        //工艺效验
        if (stage.equals(StageEnum.焊接工艺.getVerifyName())){
            //焊口编号是否上传
            String code = jsonObject.getString("code");
            if (StringUtils.isEmpty(code)) {
                return VerifyEnum.未通过.getName();
            }
            //判断人员是否效验通过
            List<Verify> welderList = verifyList.stream( ).filter(b -> b.getStage( ).equals(StageEnum.焊前人员.getStage( ))).collect(Collectors.toList( ));
            //判断管材是否效验通过
            List<Verify> materialList = verifyList.stream( ).filter(b -> b.getStage( ).equals(StageEnum.焊前管材质量.getStage( ))).collect(Collectors.toList( ));
            //判断设备是否校验通过
            List<Verify> facilityList = verifyList.stream( ).filter(b -> b.getStage( ).equals(StageEnum.焊前设备.getStage( ))).collect(Collectors.toList( ));
            if (welderList ==null ||materialList ==null || facilityList ==null || welderList.size()==0 || materialList.size()==0  || facilityList.size()==0) {
                return VerifyEnum.未通过.getName();
            }
            for (Verify v1 : welderList) {
                if (v1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
            }
            for (Verify v2 : materialList) {
                if (v2.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
            }
            for (Verify v3 : facilityList) {
                if (v3.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
            }
            //判断这个工艺是否已经校验
            //获取前端传的焊口编号(工艺阶段焊口编号必传)
           /* String code = jsonObject.getString("code");//焊口编号
            if (StringUtils.isEmpty(code)) {
                return VerifyEnum.未通过.getName();
            }
            //通过项目id 用户id 焊口编号来确定工艺阶段
            List<Verify>  list= verifyMapper.selectByWelder(projectId, welderId, code,null);
            List<Verify> collect = list.stream( ).filter(b -> b.getStage( ).equals(StageEnum.焊接工艺.getStage( ))).collect(Collectors.toList( ));
            if (collect != null && collect.size()>0) {
                for (Verify v1 : collect) {
                    if (v1 != null) {
                        if (v1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                            return VerifyEnum.未通过.getName();
                        }
                        if (v1.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                            return VerifyEnum.已通过.getName();
                        }
                    }
                }
            }*/
            //如果焊前效验已经通过进行效验步骤
            Boolean flag =false;
            verify.setStage(StageEnum.焊接工艺.getStage());
            String result = jsonObject.getString("result");
            if (VerifyEnum.已通过.getName().equals(result)) {
               flag =true;
            }
            if (!flag) {
                //校验不通过
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            this.addSuccessData(verify,null,jsonObject);
        }
        //耐压
        if (stage.equals(StageEnum.管道耐压.getVerifyName())){
            //查询工艺是否校验通过(可能有好几个焊口码)
            //获取前端传的焊口编号(工艺阶段焊口编号必传)
            String manyCode = jsonObject.getString("manyCode");//获取多个焊口编号
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            String[] codeArray = manyCode.split(",");
            //工艺的效验
            for (String code : codeArray) {
                List<Verify> verifyList1 = verifyMapper.selectByWelder(projectId, welderId, code,StageEnum.焊接工艺.getStage(),null);
                for (Verify verify1 : verifyList1) {
                    //工艺阶段未效验
                    if (verify1 == null) {
                        return VerifyEnum.未通过.getName();
                    }
                    //工艺已校验
                    if (!StringUtils.isEmpty(verify1.getStatus())&&verify1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                        return VerifyEnum.未通过.getName();
                    }
                }
            }
            //管道耐压是否已经校验,获取头部和尾部焊口,耐压之测头部和尾部

                  /*  Verify v = verifyMapper.selectByCode(manyCode, projectId, StageEnum.管道耐压.getStage());
                        if (v !=null && v.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                            return VerifyEnum.未通过.getName();
                        }
                        if (v !=null && v.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                            return VerifyEnum.已通过.getName();
                        }*/


         /*   if (codeArray !=null && codeArray.length>=2) {
                String  startCode=codeArray[0] ;
                String  endCode = codeArray[codeArray.length-1];
                List<Verify> startList = verifyMapper.selectByWelder(projectId, welderId, startCode,StageEnum.管道耐压.getStage());
                List<Verify> endList = verifyMapper.selectByWelder(projectId, welderId, endCode,StageEnum.管道耐压.getStage());
                if (startList !=null &&endList != null &&startList.size()>0 && endList.size()>0 ) {
                    for (Verify startVerity : startList) {
                        if (startVerity.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                            return VerifyEnum.未通过.getName();
                        }
                        if (startVerity.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                            return VerifyEnum.已通过.getName();
                        }

                    }
                    for (Verify endVerity : endList) {
                        if (endVerity.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                            return VerifyEnum.未通过.getName();
                        }
                        if (endVerity.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                            return VerifyEnum.已通过.getName();
                        }
                    }
                }
            }*/
            //如果工艺效验已经通过进行耐压校验步骤,(特别注意,只需要效验头部和尾部耐压)
            verify.setStage(StageEnum.管道耐压.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =true ;

            if (!flag) {
                //校验不通过
               jsonObject.put("code",manyCode);
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            this.addSuccessData(verify,codeArray,jsonObject);
        }
        //埋深
        if (stage.equals(StageEnum.敷设质量.getVerifyName())){

            //查询耐压是否校验通过
            String manyCode = jsonObject.getString("manyCode");//获取多个焊口编号
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            Verify verify1 = verifyMapper.selectByCode(manyCode, projectId, StageEnum.管道耐压.getStage( ),null);
            //耐压没有效验数据
            if (verify1 == null) {
                return VerifyEnum.未通过.getName();
            }
            //耐压有效验数据,但是不通过
            if (verify1 != null && verify1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                return VerifyEnum.未通过.getName();
            }

            //耐压校验已经通过,埋深是否已经校验
            /*Verify v = verifyMapper.selectByCode(manyCode, projectId, StageEnum.敷设质量.getStage());
            if (v != null) {
                if (v.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
                if (v.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                    return VerifyEnum.已通过.getName();
                }
            }*/
            //耐压校验已经通过,进行埋深校验
            verify.setStage(StageEnum.敷设质量.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =true ;

            if (!flag) {
                //校验不通过
                jsonObject.put("code",manyCode);
                this.addFailData(verify,jsonObject,new QualityProblem());
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            String []codeArray =manyCode.split(",");
            this.addSuccessData(verify,codeArray,jsonObject);
        }
         //定位
        if (stage.equals(StageEnum.定位.getVerifyName())){
            //查询埋深是否校验通过
            String manyCode = jsonObject.getString("manyCode");
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            Verify v1 = verifyMapper.selectByCode(manyCode, projectId, StageEnum.敷设质量.getStage( ),null);
            //埋深没有效验数据
            if (v1 == null) {
                return VerifyEnum.未通过.getName();
            }
            //埋深有效验数据,但是不通过
            if (v1 != null && v1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                return VerifyEnum.未通过.getName();
            }
            /*//埋深校验已经通过,定位是否已经校验
            Verify v = verifyMapper.selectByCode(manyCode, projectId, StageEnum.定位.getStage());
            if (v != null) {
                if (v.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
                if (v.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                    return VerifyEnum.已通过.getName();
                }
            }*/
            //耐压校验已经通过,没有埋深数据,进行埋深校验
            verify.setStage(StageEnum.定位.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =true ;

            if (!flag) {
                //校验不通过
                jsonObject.put("code",manyCode);
                QualityProblem qp = new QualityProblem( );
                this.addFailData(verify,jsonObject,qp);
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            String []codeArray =manyCode.split(",");
            this.addSuccessData(verify,codeArray,jsonObject);
        }
        //回填
        if (stage.equals(StageEnum.回填.getVerifyName())) {
            String manyCode = jsonObject.getString("manyCode");
            if (StringUtils.isEmpty(manyCode)) {
                return VerifyEnum.未通过.getName();
            }
            Verify v1 = verifyMapper.selectByCode(manyCode, projectId, StageEnum.定位.getStage( ),null);
            //判断定位没有校验数据
            if (v1 == null) {
                return VerifyEnum.未通过.getName();
            }
            //定位有效验数据,但是不通过
            if (v1 != null && v1.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                return VerifyEnum.未通过.getName();
            }
           /* //定位校验已经通过,回填是否已经校验
            Verify v2 = verifyMapper.selectByCode(manyCode, projectId, StageEnum.回填.getStage());
            if (v2 != null) {
                if (v2.getStatus().equals(VerifyEnum.未通过.getStatus())) {
                    return VerifyEnum.未通过.getName();
                }
                if (v2.getStatus().equals(VerifyEnum.已通过.getStatus())) {
                    return VerifyEnum.已通过.getName();
                }
            }*/
            //定位校验已经通过,没有回填数据,进行回填校验
            verify.setStage(StageEnum.回填.getStage());
            verify.setCode(manyCode);
            /**
             * 效验假数据
             */
            Boolean flag =false ;

            if (!flag) {
                //校验不通过
                jsonObject.put("code",manyCode);
                QualityProblem qualityProblem = new QualityProblem( );
                this.addFailData(verify,jsonObject,qualityProblem);
                return VerifyEnum.未通过.getName();
            }
            //效验通过
            String []codeArray =manyCode.split(",");
            this.addSuccessData(verify,codeArray,jsonObject);


        }
        return VerifyEnum.已通过.getName();
    }





    /**  cpp
     * 校验失败需要添加的数据
     * @param verify
     * @param qualityProblem
     */
    public void addFailData(Verify verify,JSONObject jsonObject,QualityProblem qualityProblem){
        //校验不通过，存入校验信息，
        verify.setStatus(VerifyEnum.未通过.getStatus());
        try {
            //智能监检管理表添加数据

            boolean save = this.save(verify);
        } catch (Exception e) {
            e.printStackTrace();

        }
        //质量问题表添加数据
        qualityProblem.setProjectId(verify.getProjectId());
        qualityProblem.setSubmitDate(new Date());
        //随机生成四位数
        String random = String.valueOf((int) ((Math.random( ) * 9 + 1) * 1000));
        if (!StringUtils.isEmpty(jsonObject.getString("code"))) {
            String code = jsonObject.getString("code");//获取焊口编码
            qualityProblem.setCode(code+"-WT"+random);
        }
        String stage = jsonObject.getString("stage");//获取效验阶段
        qualityProblem.setGenerateStage(stage);
        qualityProblem.setProblemDescribe(stage+"不通过");
        //获取智能监检表id
        Verify verify1 = verifyMapper.selectByTargetInfo(verify.getTargetInfo( ));
        Long sequenceNbr = verify1.getSequenceNbr( );
        qualityProblem.setStageVerifyId(sequenceNbr);
        qualityProblemService.save(qualityProblem);

    }




    /**   cpp
     * 校验成功需要添加的数据
     * @param verify
     * @param
     */
    public void addSuccessData(Verify verify,String[] codeArray,JSONObject js){
        //效验通过状态
        verify.setStatus(VerifyEnum.已通过.getStatus());

        try {

            //智能监检管理表添加数据
            this.save(verify);
        } catch (Exception e) {
            e.printStackTrace( );
        }
        //焊口表修改状态
        if (codeArray ==null || codeArray.length==0) {
            String targetInfo = verify.getTargetInfo( );
            JSONObject jsonObject = JSONObject.parseObject(targetInfo);
            String code = jsonObject.getString("code");//获取焊口编号
            // 通过焊口码和项目id查询
            if (!StringUtils.isEmpty(code)&& verify.getProjectId() !=null) {

                Weld weld=weldMapper.getWeldByCodeAndProjectId(code, verify.getProjectId());
                if (weld != null) {
                    //判断是哪一个阶段
                    String stage = verify.getStage( );
                    Map<String, String> mapEnum = StageEnum.getStageByNameMap;
                    //修改的值
                    String name = mapEnum.get(stage);
                    weld.setSuperInspecStatus(name);//更改监检状态
                    try {
                        //修改
                        int i = weldMapper.updateById(weld);
                    } catch (Exception e) {
                        e.printStackTrace( );
                    }
                }
            }
        }
        if (codeArray !=null && codeArray.length>0) {
            for (String code : codeArray) {
                if (!StringUtils.isEmpty(code)&& verify.getProjectId() !=null) {
                    Weld weld=weldMapper.getWeldByCodeAndProjectId(code, verify.getProjectId());
                    if (weld != null) {
                        //判断是哪一个阶段
                        String stage = verify.getStage( );
                        Map<String, String> mapEnum = StageEnum.getStageByNameMap;
                        //修改的值
                        String name = mapEnum.get(stage);
                        weld.setSuperInspecStatus(name);//更改监检状态
                        try {
                            //修改
                            int i = weldMapper.updateById(weld);
                        } catch (Exception e) {
                            e.printStackTrace( );
                        }
                    }
                }
            }

        }
    }


    /**
     * 主键id查询  (图片和结果)
     * @param sequenceNbr
     * @return
     */
    public OpenDto selectById(Long sequenceNbr){

        Verify verify = verifyMapper.selectById(sequenceNbr);
        OpenDto openDto = new OpenDto( );
        if (verify !=null && !StringUtils.isEmpty( verify.getStatus())) {
            String targetInfo=  verify.getTargetInfo();
            //获取照片
            openDto.setNewPhoto("https://img2.baidu.com/it/u=806791452,2765805606&fm=253&fmt=auto&app=138&f=JPEG?w=350&h=500");
            openDto.setOldPhoto("https://img2.baidu.com/it/u=1534411088,173440019&fm=253&app=138&size=w931&n=0&f=JPEG&fmt=auto?sec=1666976400&t=3e985017d01fe1c0cfe639335abc2fe8");
            if (verify.getStatus().equals("0")) {
                openDto.setResult(VerifyEnum.未通过.getName());
            }
            if (verify.getStatus().equals("1")) {
                openDto.setResult(VerifyEnum.已通过.getName());
            }

            //符合性
            openDto.setAccord("符合");
            //有效性
            openDto.setValid("有效");
        }
        return openDto ;
    }








}
