package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrDto;
import com.yeejoin.amos.boot.module.ugp.api.Enum.OrgEnum;
import com.yeejoin.amos.boot.module.ugp.api.Enum.ProjectResourceEnum;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectResource;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import com.yeejoin.amos.feign.privilege.util.DesUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class WelderServiceImpl {

    @Autowired
    OrgServiceImpl orgService;

    @Autowired
    ProjectServiceImpl projectService;

    @Autowired
    ProjectResourceServiceImpl projectResourceService;

    @Value("${amos.secret.key}")
    String secretKey;


    /**
     * 获取当前登录所在单位下的项目中的所有焊工列表
     * @return
     */
    @BusinessIdentify
    public List<Map> getInfo(){
        List<Project> projectList = projectResourceService.getProjectList();
        List<Long> projectIdList = new ArrayList<>();
        List<Long> welderIdList = new ArrayList<>();
        for(Project project:projectList){
            projectIdList.add(project.getSequenceNbr());
        }
        for(Long projectId:projectIdList){
            LambdaQueryWrapper<ProjectResource> projectResourceWrapper = new LambdaQueryWrapper<>();
            projectResourceWrapper.eq(ProjectResource::getType, ProjectResourceEnum.焊工资源.getCode())
                    .eq(ProjectResource::getProjectId,projectId);
            List<ProjectResource> projectResourceList = projectResourceService.list(projectResourceWrapper);
            for(ProjectResource projectResource : projectResourceList){
                welderIdList.add(projectResource.getResourceId());
            }
        }
        List<Map> mapList = new ArrayList<>();
        for(Long welderId:welderIdList){
            mapList.add(orgService.getdetialInfo(String.valueOf(welderId)));
        }
        return mapList;
    }

    public IPage<Map> getpageInfo(){
        IPage<Map> page = new Page<>();
        page.setSize(getInfo().size());
        page.setCurrent(1L);
        page.setRecords(getInfo());
        page.setTotal(getInfo().size());
        return page;
    }

    /**
     * 存人员信息至业务表及平台表
     * @param jsonObject
     * @param bizOrgType
     * @param sequenceNbr
     * @return
     */
    @BusinessIdentify
    public OrgUsrDto savePerson(JSONObject jsonObject, String bizOrgType, String sequenceNbr){
        if(ValidationUtil.isEmpty(sequenceNbr)){
            Long companyId = orgService.getReginParams().getCompany().getSequenceNbr();
            Set<String> roleNameSet = new HashSet<>();
            List<RoleModel> userRoleList = new ArrayList<>();
            List<Long> roleIds = new ArrayList<>();
            Map<Long, List<Long>> roleSeqsMap = new HashMap<>();
            AgencyUserModel agencyUserModel = new AgencyUserModel();
            Map<Long,List<RoleModel>> orgRoles = new HashMap<>();
            //用户基本信息
            agencyUserModel.setRealName(jsonObject.getString("name"));
            agencyUserModel.setAgencyCode("ugp");
            agencyUserModel.setLockStatus("UNLOCK");
            agencyUserModel.setMobile(jsonObject.getString("phone"));
            agencyUserModel.setCreateTime(new Date());
            agencyUserModel.setUserName(jsonObject.getString("phone"));
            agencyUserModel.setPassword(DesUtil.encode(jsonObject.getString("phone"), secretKey));
            agencyUserModel.setRePassword(DesUtil.encode(jsonObject.getString("phone"), secretKey));
            //用户角色信息
            List<RoleModel> allRoleList = Privilege.roleClient.queryRoleList(null,null).getResult();
            if(1==jsonObject.getInteger("isWelder")){
                roleNameSet.add(OrgEnum.焊工.getName());
            } else {
                roleNameSet.add(OrgEnum.普通人员.getName());
            }
            userRoleList = allRoleList.stream().filter(r -> r.getRoleName().equals(roleNameSet)).collect(Collectors.toList());
            userRoleList.stream().forEach(r -> {
                if (!roleIds.contains(r.getSequenceNbr())) {
                    roleIds.add(r.getSequenceNbr());
                }
            });
            roleSeqsMap.put(companyId,roleIds);
            orgRoles.put(companyId,userRoleList);
            agencyUserModel.setOrgRoleSeqs(roleSeqsMap);
            agencyUserModel.setOrgRoles(orgRoles);
            //创建用户
            agencyUserModel = Privilege.agencyUserClient.create(agencyUserModel).getResult();
            jsonObject.put("amosOrgId",agencyUserModel.getSequenceNbr());
        }

        return orgService.dataHandling(jsonObject,bizOrgType,sequenceNbr);
    }
}
