package com.yeejoin.amos.api.openapi.face.service;

import com.yeejoin.amos.api.openapi.face.model.RegistrationInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.MidEquipRegistrationInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidEquipRegistrationInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * 特种设备基本信息-注册登记信息  服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class RegistrationInfoService extends AppBaseService<RegistrationInfoModel, MidEquipRegistrationInfo, MidEquipRegistrationInfoMapper> {

    @Autowired
    private JgFileService fileService;

    /**
     *
     * 新增注册登记信息
     *
     * @param model 注册登记信息model集合
     * @return  成功返回“ok” 失败返回“Access_token无效”
     */
    @Transactional(rollbackFor= {Exception.class})
    public String saveRegistrationInfo(List<RegistrationInfoModel> model) {
        // TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("注册登记信息为空.");
        }

//        List<JgFile> fileList = new ArrayList<>();
//        List<JgFile> useRegistCertificateList;

        for (RegistrationInfoModel models : model) {
//            checkModel(models);
            models.setRecDate(new Date());
            models.setAppId(getAppId());

            RegistrationInfoModel registrationInfoModel = this.createWithModel(models);

//            useRegistCertificateList = JSONObject.parseArray(JSONObject.toJSONString(models.getUseRegistCertificate()), JgFile.class);
//
//            for (JgFile files : useRegistCertificateList) {
//                JgFile file = new JgFile();
//                file.setSequenceCode(models.getSequenceCode());
//                file.setAppId(getAppId());
//                file.setObjectType(JgFileObjectEnum.REGISTRATION_INFO.getObject());
//                file.setAttributeType(JgFileAttributeEnum.USE_REGIST_CERTIFICATE.getAttribute());
//                file.setSyncDate(models.getSyncDate());
//                file.setFileUrl(files.getFileUrl());
//                file.setFileName(files.getFileName());
//                file.setRecDate(new Date());
//                file.setSquNbr(registrationInfoModel.getSequenceNbr());
//                fileList.add(file);
//            }
        }
//        fileService.saveBatch(fileList);
        return "OK";
    }

    /**
     * 信息校验
     *
     * @param models
     */
//    private static void checkModel(RegistrationInfoModel models) {
//        if(ValidationUtil.isEmpty(models.getSequenceCode())) {
//            throw new BadRequest("设备唯一标识码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSuperviseCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监管系统唯一编码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getUseOrgCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"使用登记证编号不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getEquCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备代码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getOrganizationCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"登记机关组织机构代码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getOrganizationName())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"登记机关名称不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getUseOrgId())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"使用登记ID不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getEquList())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备种类不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getEquCategory())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备类别不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getEquDefine())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备品种不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getProductName())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"产品名称不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getEquType())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"设备型号不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getUseRegistCertificate())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"使用登记证附件不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncDate())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步时间不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncState())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步状态不能为空！");
//        }
//    }
}
