package com.yeejoin.amos.boot.module.common.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 值班人员日期关联关系表
 *
 * @author system_generator
 * @date 2021-07-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DutyPersonShiftDto", description = "值班人员日期关联关系表")
public class DutyPersonShiftDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "值班日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date dutyDate;

    @ApiModelProperty(value = "值班班次id")
    private Long shiftId;

    @ApiModelProperty(value = "实例id")
    private Long instanceId;

    @ApiModelProperty(value = "更新人员")
    private String recUserName;

    @ApiModelProperty(value = "班次名称")
    private String shiftName;

    @ApiModelProperty(value = "应用标识（数据隔离使用）")
    private String appKey;

    @ApiModelProperty(value = "颜色")
    private String color;

}
