package com.yeejoin.amos.boot.module.cylinder.flc.biz.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl.CylinderAreaDataServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

@RestController
@Api(tags = "气瓶统计Api")
@RequestMapping(value = "/statistics")
public class CylinderStatisticsController {


    @Autowired
    private CylinderAreaDataServiceImpl service;

    /**
     * 预警预报统计
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/earlyWarning", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "预警预报")
    public ResponseModel<Page<Map<String, Object>>> getEarlyWarning(@RequestParam(value = "regionCode", required = false) String regionCode, @RequestParam(value = "appId", required = false) String appId) {
        return ResponseHelper.buildResponse(service.getEarlyWarningStatistics(regionCode, appId));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/test/saveCylinderFillingRecord2ES", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "testSaveCylinderFillingRecord2ES")
    public ResponseModel testSaveCylinderFillingRecord2ES() {
        return ResponseHelper.buildResponse(service.testSaveCylinderFillingRecord2ES());
    }

}
