package com.yeejoin.amos.boot.module.jczs.api.dto;


import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 用户资质信息
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TzsUseInfo", description = "用户资质信息")
public class TzsUserQualificationsDto extends BaseDto {



    @ApiModelProperty(value = "证书类型")
    private String certificateType;

    @ApiModelProperty(value = "证书编号")
    private String certificateNum;

    @ApiModelProperty(value = "发证机关")
    private String issuingUnit;


    @ApiModelProperty(value = "作业项目id")
    private String projectId;


    @ApiModelProperty(value = "发证日志")
    private Date issuingDate;


    @ApiModelProperty(value = "有效期")
    private String expirationDate;


    @ApiModelProperty(value = "附件")
    private String file;

    @ApiModelProperty(value = "用户信息id")
    private String userInfoId;
}
