package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum EquipTypeEnum {
    锅炉("锅", "1"),
    压力容器("容", "2"),
    电梯("梯", "3"),
    起重机械("起", "4"),
    场内机动车辆("车", "5"),
    大型游乐设施("游", "6"),
    压力管道("管", "8"),
    客运索道("索", "9");


    private final String name;

    private final String code;

    public static String getMessage(String code) {
        for (EquipTypeEnum constants : values()) {
            if (constants.getCode().equals(code)) {
                return constants.getName();
            }
        }
        return null;
    }
}
