package com.yeejoin.amos.boot.module.jyjc.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.jyjc.api.dto.InspectTimeCountDto;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationEquip;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-14
 */
public interface JyjcInspectionApplicationEquipMapper extends BaseMapper<JyjcInspectionApplicationEquip> {
    public void deleteByApplicationSeq(Long applicationSeq);

    /**
     * 检验检测次数统计维度按照设备种类、检验类型进行统计
     *
     * @param dpFilterParamDto 过滤条件时间
     * @param orgCode          过滤条件区域对应的公司的orgCode
     * @return 统计列表
     */
    List<InspectTimeCountDto> countInspectTimeCountByTypeAndEquList(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto dpFilterParamDto);

    Integer inspectTimeCount(@Param("dpFilterParamDto") DPFilterParamDto dpFilterParamDto);

    List<JyjcInspectionApplicationEquip> queryWaitFlushData();
}
