package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import com.yeejoin.amos.boot.module.jyjc.api.dto.InspectMockAppData;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationEquip;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultParam;
import com.yeejoin.amos.boot.module.jyjc.api.enums.JYJCTypeEnum;
import com.yeejoin.amos.boot.module.jyjc.api.enums.ResultStatusEnum;
import com.yeejoin.amos.boot.module.jyjc.api.enums.ResultTypeEnum;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionApplicationModel;
import com.yeejoin.amos.boot.module.jyjc.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgOtherInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgProjectContraptionMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgUseInfoMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
public class InspectAppMockServiceImpl {

    private final SnowflakeIdUtil sequence;

    private final IdxBizJgUseInfoMapper useInfoMapper;

    private final TzsServiceFeignClient tzsServiceFeignClient;

    private final JyjcInspectionResultServiceImpl inspectionResultService;

    @Autowired
    private JyjcInspectionResultParamServiceImpl jyjcInspectionResultParamServiceImpl;

    private final JyjcInspectionApplicationServiceImpl jyjcInspectionApplicationService;

    private final JyjcInspectionApplicationEquipServiceImpl jyjcInspectionApplicationEquipService;

    private final IdxBizJgProjectContraptionMapper idxBizJgProjectContraptionMapper;


    @Transactional(rollbackFor = Exception.class)
    public Boolean testAppAndPassApp(InspectMockAppData appData) {
        if (appData.getSize() > 10) {
            appData.setSize(1);
        }
        // 1.查询设备：equList + equCategory + equDefine + useUnitCode
        List<IdxBizJgOtherInfo> records = useInfoMapper.selectOneMockRecord(appData.getEquList(), appData.getEquCategory(), appData.getEquDefine(), appData.getApplicationUnitCode(), appData.getSize());
        if (records.isEmpty()) {
            throw new RuntimeException("未找到符合条件的设备！");
        }
        Date now = new Date();
        // 2.插入申请数据
        JyjcInspectionApplication application = saveJyjcInspectionApplication(appData, now, records);
        // 3.插入报检数据
        List<JyjcInspectionApplicationEquip> equips = saveJyjcInspectionApplicationEquips(appData, records, application, now);
        // 4.插入初始结果数据
        saveResultData(application, now, equips);
        // 5.推送
        jyjcInspectionApplicationService.pushInspectionApplication(BeanUtil.copyProperties(application, JyjcInspectionApplicationModel.class));
        return Boolean.TRUE;
    }

    private void saveResultData(JyjcInspectionApplication application, Date now, List<JyjcInspectionApplicationEquip> equips) {
        List<JyjcInspectionResult> resultModels = new ArrayList<>();
        if (application.getEquipClassify().equals(EquipmentClassifityEnum.YLGD.getCode())) {
            List<String> codes1 = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.SE.getCode(), 1).getResult();
            JyjcInspectionResult jyjcInspectionResult = new JyjcInspectionResult();
            jyjcInspectionResult.setInspectionUnitCode(application.getInspectionUnitCode());
            jyjcInspectionResult.setInspectionUnitName(application.getInspectionUnitName());
            jyjcInspectionResult.setApplicationNo(application.getApplicationNo());
            jyjcInspectionResult.setApplicationUnitCode(application.getApplicationUnitCode());
            jyjcInspectionResult.setApplicationUnitName(application.getApplicationUnitName());
            jyjcInspectionResult.setResultStatus(ResultStatusEnum.NO_RESULT.getCode());
            jyjcInspectionResult.setApplicationDate(application.getApplicationDate());
            jyjcInspectionResult.setRecDate(now);
            jyjcInspectionResult.setInspectionType(application.getInspectionType());
            jyjcInspectionResult.setInspectionTypeName(jyjcInspectionApplicationService.getDictNameByCode(application.getInspectionType()));
            // 解析设备
            jyjcInspectionResult.setBizType(application.getBizType());
            jyjcInspectionResult.setResultNo(codes1.get(0));
            // 装置信息查询
            jyjcInspectionResult.setEquipUnicode(application.getProjectContraptionId());
            IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionMapper.selectById(application.getProjectContraptionId());
            if (projectContraption != null) {
                jyjcInspectionResult.setEquipUnicode(projectContraption.getSequenceNbr() + "");
                jyjcInspectionResult.setSupervisoryCode(projectContraption.getSupervisoryCode());
                jyjcInspectionResult.setEquCategory(projectContraption.getEquCategory());
                jyjcInspectionResult.setEquList(projectContraption.getEquList());
                jyjcInspectionResult.setEquDefine(projectContraption.getEquDefine());
            }
            Long resultSeq = sequence.nextId();
            jyjcInspectionResult.setSequenceNbr(resultSeq);
            jyjcInspectionResult.setIsExistNc(false);
            jyjcInspectionResult.setManageType("batch");
            jyjcInspectionResult.setResultType(application.getResultType());
            resultModels.add(jyjcInspectionResult);
            // TODO 以管道汇总样式表暂存json,在结果录入后，将数据更新技术参数,考虑老数据
            Map<String, Object> paramDetail = jyjcInspectionApplicationService.getDeviceListByProjectContraption3(Bean.toModel(application, new JyjcInspectionApplicationModel()));
            JyjcInspectionResultParam resultParam = new JyjcInspectionResultParam();
            resultParam.setResultSeq(jyjcInspectionResult.getSequenceNbr());
            resultParam.setParamJson(JSON.toJSONString(paramDetail));
            resultParam.setParamType("IdxBizJgTechParamsPipeline");
            resultParam.setRecDate(now);
            jyjcInspectionResultParamServiceImpl.save(resultParam);
        } else {
            List<String> codes1 = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.SE.getCode(), equips.size()).getResult();
            for (int i = 0; i < equips.size(); i++) {
                JyjcInspectionResult jyjcInspectionResult = new JyjcInspectionResult();
                jyjcInspectionResult.setInspectionUnitCode(application.getInspectionUnitCode());
                jyjcInspectionResult.setInspectionUnitName(application.getInspectionUnitName());
                jyjcInspectionResult.setApplicationNo(application.getApplicationNo());
                jyjcInspectionResult.setApplicationUnitCode(application.getApplicationUnitCode());
                jyjcInspectionResult.setApplicationUnitName(application.getApplicationUnitName());
                jyjcInspectionResult.setResultStatus(ResultStatusEnum.NO_RESULT.getCode());
                jyjcInspectionResult.setApplicationDate(application.getApplicationDate());
                jyjcInspectionResult.setRecDate(now);
                jyjcInspectionResult.setInspectionType(application.getInspectionType());
                jyjcInspectionResult.setInspectionTypeName(jyjcInspectionApplicationService.getDictNameByCode(application.getInspectionType()));
                // 解析设备
                jyjcInspectionResult.setBizType(application.getBizType());
                jyjcInspectionResult.setResultNo(codes1.get(i));
                //设备唯一标识
                jyjcInspectionResult.setEquipUnicode(equips.get(i).getEquipUnicode());
                jyjcInspectionResult.setSupervisoryCode(equips.get(i).getSupervisoryCode());
                jyjcInspectionResult.setEquDefine(equips.get(i).getEquDefine());
                jyjcInspectionResult.setEquCategory(equips.get(i).getEquCategory());
                jyjcInspectionResult.setEquList(equips.get(i).getEquList());
                jyjcInspectionResult.setIsExistNc(false);
                jyjcInspectionResult.setResultType(application.getResultType());
                Long resultSeq = sequence.nextId();
                jyjcInspectionResult.setSequenceNbr(resultSeq);
                resultModels.add(jyjcInspectionResult);
            }
        }
        inspectionResultService.saveOrUpdateBatch(resultModels);
    }

    private List<JyjcInspectionApplicationEquip> saveJyjcInspectionApplicationEquips(InspectMockAppData appData, List<IdxBizJgOtherInfo> records, JyjcInspectionApplication application, Date now) {
        List<JyjcInspectionApplicationEquip> equips = records.stream().map(otherInfo -> {
            JyjcInspectionApplicationEquip equip = new JyjcInspectionApplicationEquip();
            equip.setApplicationSeq(application.getSequenceNbr());
            equip.setEquipUnicode(otherInfo.getRecord());
            equip.setEquList(appData.getEquList());
            equip.setEquCategory(appData.getEquCategory());
            equip.setEquDefine(appData.getEquDefine());
            equip.setRecUserId(RequestContext.getExeUserId());
            equip.setRecDate(now);
            equip.setSupervisoryCode(otherInfo.getSupervisoryCode());
            equip.setProjectContraptionId(application.getProjectContraptionId());
            return equip;
        }).collect(Collectors.toList());
        jyjcInspectionApplicationEquipService.saveBatch(equips);
        return equips;
    }

    private JyjcInspectionApplication saveJyjcInspectionApplication(InspectMockAppData appData, Date now, List<IdxBizJgOtherInfo> records) {
        List<String> codes = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.JY.getCode(), 1).getResult();
        JyjcInspectionApplication application = new JyjcInspectionApplication();
        application.setApplicationNo(codes.get(0));
        application.setInspectionUnitCode(appData.getInspectionUnitCode());
        application.setInspectionUnitName(appData.getInspectionUnitName());
        application.setInspectionType(appData.getInspectType());
        application.setEquipClassify(appData.getEquList());
        application.setEquCategory(appData.getEquCategory());
        application.setEquDefine(appData.getEquDefine());
        application.setApplicationDate(now);
        application.setApplicationUnitName(appData.getApplicationUnitName());
        application.setApplicationUnitCode(appData.getApplicationUnitCode());
        application.setApplicationContactName(appData.getApplicationContactName());
        application.setApplicationContactPhone(appData.getApplicationContactPhone());
        application.setAcceptDate(now);
        application.setNumberOfEquip(appData.getSize());
        application.setStatus(FlowStatusEnum.TO_BE_FINISHED.getCode() + "");
        application.setRecDate(now);
        application.setProjectContraptionId(useInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, records.get(0).getRecord())).getProjectContraptionId());
        application.setRecUserId(RequestContext.getExeUserId());
        application.setBizType(JYJCTypeEnum.of(appData.getInspectType()).getBizType());
        application.setResultType(ResultTypeEnum.INTEGRATED.getCode());
        application.setDockingUnitCode(appData.getAppId());
        jyjcInspectionApplicationService.save(application);
        return application;
    }
}
