package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.TreeRecursive;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.StCommonServiceImpl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@Api(tags = "统计公共API")
@RequestMapping(value = "/st-common")
public class StCommonController extends BaseController {

    private ObjectMapper objectMapper = new ObjectMapper();

    private StCommonServiceImpl commonService;

    public StCommonController(StCommonServiceImpl commonService) {
        this.commonService = commonService;
    }

    /**
     * 获取用户regionCode
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getUserRegincode")
    @ApiOperation(httpMethod = "GET", value = "获取用户regionCode", notes = "获取用户regionCode")
    public ResponseModel<List<RegionModel>> getUserReginCode() {
        List<RegionModel> regionList = commonService.getUserRegionCode(getSelectedOrgInfo());
        return ResponseHelper.buildResponse(regionList);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/3level/region-tree")
    @ApiOperation(httpMethod = "GET", value = "获取用户regionCode", notes = "获取用户regionCode")
    public ResponseModel<List<RegionModel>> getReginTree(@RequestParam(value = "regionCode") Integer regionCode) {
        List<RegionModel> regionList = commonService.getRegionTree3Level(regionCode);
        return ResponseHelper.buildResponse(regionList);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/4level/region-tree")
    @ApiOperation(httpMethod = "GET", value = "获取用户regionCode", notes = "获取用户regionCode")
    public ResponseModel<List<RegionModel>> getReginTreeFor4Level(@RequestParam(value = "regionCode") Integer regionCode) {
        List<RegionModel> regionList = commonService.getReginTreeFor4Level(regionCode);
        return ResponseHelper.buildResponse(regionList);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/4level/region-tree")
    @ApiOperation(httpMethod = "POST", value = "获取用户regionCode,POST方式", notes = "获取用户regionCode,POST方式")
    public ResponseModel<Object> ReginTreeFor4LevelWithPost(@RequestBody JSONObject jsonObj) {
        List<RegionModel> regionList = commonService.getReginTreeFor4Level(Integer.valueOf(jsonObj.getString("cityCode")));
        List<Map<String, Object>> regionMapList = regionList.stream()
                .map(this::convertRegionToMap)
                .collect(Collectors.toList());
        List<Map<String, Object>> treeData = TreeRecursive.recursive(regionMapList)
                .mapTree(node -> {
                    Map<String, Object> newNode = new HashMap<>(node);
                    newNode.put("key", node.get("regionCode").toString());
                    newNode.put("value", node.get("regionCode").toString());
                    newNode.put("label", node.get("regionName").toString());
                    newNode.put("title", node.get("regionName").toString());
                    return newNode;
                });
        return ResponseHelper.buildResponse(treeData);
    }

    private Map<String, Object> convertRegionToMap(RegionModel region) {
        Map<String, Object> map = new HashMap<>();

        map.put("regionCode", region.getRegionCode());
        map.put("regionName", region.getRegionName());
        if (region.getChildren() != null && !region.getChildren().isEmpty()) {
            List<Map<String, Object>> children = region.getChildren().stream()
                    .map(this::convertRegionToMap)
                    .collect(Collectors.toList());
            map.put("children", children);
        } else {
            map.put("children", Collections.emptyList());
        }
        return map;
    }

    /**
     * 获取设备类型
     * @return Map
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getEquCategoryTree")
    @ApiOperation(httpMethod = "POST", value = "获取设备类型", notes = "获取设备类型")
    public ResponseModel<JSONArray> getEquCategoryTree(@RequestBody DPFilterParamForDetailDto paramDto){
        JSONArray objects = new JSONArray();
        objects.add(commonService.getEquCategoryTree(paramDto));
        return ResponseHelper.buildResponse(objects);
    }
}
