package com.yeejoin.amos.boot.module.tcm.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author litw
 * @date 2021-09-26.
 */
@Data
@ApiModel(value="EsElevatorDto", description="ES电梯信息")
public class EsElevatorDto {


    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 电梯id
     */
    @ApiModelProperty(value = "电梯id")
    private Long sequenceNbr;

    /**
     * 注册编码
     */
    @ApiModelProperty(value = "注册编码")
    private String registerCode;

    /**
     * 所属省
     */
    @ApiModelProperty(value = "所属省")
    private String province;

    /**
     * 所属地市
     */
    @ApiModelProperty(value = "所属地市")
    private String city;

    /**
     * 所属区县
     */
    @ApiModelProperty(value = "所属区县")
    private String district;

    /**
     * 所属区域代码
     */
    @ApiModelProperty(value = "所属区域代码")
    private String regionCode;

    /**
     * 电梯识别码
     */
    @ApiModelProperty(value = "电梯识别码")
    private Integer rescueCode;

    /**
     * 电梯经度
     */
    @ApiModelProperty(value = "电梯经度")
    private String longitude;

    /**
     * 电梯纬度
     */
    @ApiModelProperty(value = "电梯纬度")
    private String latitude;

    /**
     * 地址
     */
    @ApiModelProperty(value = "地址")
    private String address;

    /**
     * 警情类型code
     */
    @ApiModelProperty(value = "警情类型")
    private String alarmTypeCode;

    /**
     * 警情id
     */
    @ApiModelProperty(value = "警情id")
    private String alertId;

    /**
     * 是否当天
     */
    @ApiModelProperty(value = "是否当天")
    private Boolean isToday ;

    /**
     * 发生时间
     */
    @ApiModelProperty(value = "发生时间")
    private Date happenTime ;

    /**
     * 故障类型
     */
    @ApiModelProperty(value = "故障类型")
    private String type ;

    /**
     * 物联服务提供商
     */
    @ApiModelProperty(value = "物联服务提供商")
    private String IOTServiceProvider ;

    /**
     * 处置状态
     */
    @ApiModelProperty(value = "处置状态")
    private String status ;

    /**
     * 设备种类
     */
    @ApiModelProperty(value = "设备种类")
    private String category ;

}
