package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.MainPersonDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.WechatMyTaskDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.WechatMyTaskListDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.DispatchTask;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 派遣任务 Mapper 接口
 *
 * @author kongfm
 * @date 2021-08-03
 */
public interface DispatchTaskMapper extends BaseMapper<DispatchTask> {

    String returnDistanceByTaskId(@Param("taskId") Long taskId, @Param("lon") String lon, @Param("lat") String lat);

    WechatMyTaskDto getTaskInfoByTaskId(@Param("taskId") Long taskId);

    List<WechatMyTaskListDto> getTaskListByPhonePager(@Param("phone") String phone, @Param("typeCode") String typeCode, @Param("current") Long current);

    List<MainPersonDto> todayTaskPerson();

    List<Map<String, Object>> rankUnitByRescueTime(@Param("regionCode") String regionCode);

    Page<Map<String, Object>> rankUnitByRescueTimePage(@Param("page") Page<Map<String, Object>> page, @Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);

    Map<String, Object> rankUnitByRescueTimeDetail(@Param("orgCode") String orgCode);
}
