package com.yeejoin.amos.boot.module.ys.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 应急专家库
 *
 * @author system_generator
 * @date 2024-09-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="YsEmergencyExpertsDto", description="应急专家库")
public class YsEmergencyExpertsDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "姓名")
    private String name;

    @ApiModelProperty(value = "性别")
    private String gender;

    @ApiModelProperty(value = "身份证号")
    private String identity;

    @ApiModelProperty(value = "办公电话")
    private String phone;

    @ApiModelProperty(value = "照片")
    private JSONArray photo;

    @ApiModelProperty(value = "移动电话")
    private String mobilePhone;

    @ApiModelProperty(value = "住址")
    private String address;

    @ApiModelProperty(value = "出生日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date birthdate;

    @ApiModelProperty(value = "籍贯")
    private String birthPlace;

    @ApiModelProperty(value = "所在单位")
    private String company;

    @ApiModelProperty(value = "通讯地址")
    private String contactAddress;

    @ApiModelProperty(value = "学历")
    private String education;

    @ApiModelProperty(value = "专家领域")
    private String field;

    @ApiModelProperty(value = "家庭电话")
    private String homePhone;

    @ApiModelProperty(value = "部门代码")
    private String orgCode;

    @ApiModelProperty(value = "职务")
    private String position;

    @ApiModelProperty(value = "邮政编码")
    private String postcode;

    @ApiModelProperty(value = "消防单位id")
    private String xfdwid;

    @ApiModelProperty(value = "创建时间")
    private Date createDate;

    @ApiModelProperty(value = "创建人id ")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

}
