package com.yeejoin.amos.boot.module.ccs.api.service;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface IStatisticsService {
    /**
     * 告警隐患统计
     * @param stationCode 站编号
     * @return Map<String, Object>
     */
    Map<String, Object> alarmAndDangerNumCount(String stationCode) throws ParseException;

    /**
     * 告警和隐患趋势
     * @param stationCode 换流站编号
     * @param beginDate 开始日期
     * @param endDate 结束日期
     * @return Map<String, Object>
     */
    Map<String, Object> alarmAndDangerTrend(String stationCode, String beginDate, String endDate);
}
