package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireAlarmDayStatisticsDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireAlarmDayStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 换流站告警日统计
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "换流站告警日统计Api")
@RequestMapping(value = "/fire-alarm-day-statistics")
public class FireAlarmDayStatisticsController extends BaseController {

    @Autowired
    FireAlarmDayStatisticsServiceImpl fireAlarmDayStatisticsServiceImpl;

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "换流站告警日统计列表全部数据查询", notes = "换流站告警日统计列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireAlarmDayStatisticsDto>> selectForList() {
        return ResponseHelper.buildResponse(fireAlarmDayStatisticsServiceImpl.queryForFireAlarmDayStatisticsList());
    }
}
