package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireFmeaStatisticsDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireFmeaStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 发生率/严重度矩阵统计表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "发生率/严重度矩阵统计表Api")
@RequestMapping(value = "/fire-fmea-statistics")
public class FireFmeaStatisticsController extends BaseController {

    @Autowired
    FireFmeaStatisticsServiceImpl fireFmeaStatisticsServiceImpl;

    /**
     * 新增发生率/严重度矩阵统计表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增发生率/严重度矩阵统计表", notes = "新增发生率/严重度矩阵统计表")
    public ResponseModel<FireFmeaStatisticsDto> save(@RequestBody FireFmeaStatisticsDto model) {
        model = fireFmeaStatisticsServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新发生率/严重度矩阵统计表", notes = "根据sequenceNbr更新发生率/严重度矩阵统计表")
    public ResponseModel<FireFmeaStatisticsDto> updateBySequenceNbrFireFmeaStatistics(@RequestBody FireFmeaStatisticsDto model, @PathVariable(value = "sequenceNbr") String sequenceNbr) {
        model.setId(sequenceNbr);
        return ResponseHelper.buildResponse(fireFmeaStatisticsServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除发生率/严重度矩阵统计表", notes = "根据sequenceNbr删除发生率/严重度矩阵统计表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireFmeaStatisticsServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个发生率/严重度矩阵统计表", notes = "根据sequenceNbr查询单个发生率/严重度矩阵统计表")
    public ResponseModel<FireFmeaStatisticsDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireFmeaStatisticsServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "发生率/严重度矩阵统计表分页查询", notes = "发生率/严重度矩阵统计表分页查询")
    public ResponseModel<Page<FireFmeaStatisticsDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<FireFmeaStatisticsDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireFmeaStatisticsServiceImpl.queryForFireFmeaStatisticsPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "发生率/严重度矩阵统计表列表全部数据查询", notes = "发生率/严重度矩阵统计表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireFmeaStatisticsDto>> selectForList() {
        return ResponseHelper.buildResponse(fireFmeaStatisticsServiceImpl.queryForFireFmeaStatisticsList());
    }
}
