package com.yeejoin.amos.latentdanger.business.dto;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @Author: xl
 * @Description: 隐患规则实体
 * @Date: 2021/11/12 14:44
 */
@Data
@RuleFact(value = "隐患",project = "消息规则")
public class LatentDangerRo implements Serializable {

    private static final long serialVersionUID = -2985122485796921797L;

    @Label("隐患名称")
    private String dangerName;

    @Label(value = "隐患等级名称")
    private String dangerLevelName;

    @Label(value = "执行方法")
    private String ruleType;

    @Label(value = "整改类型名称")
    private String reformTypeName;

    @Label(value = "隐患状态名称")
    private String dangerStateName;

    @Label(value = "执行状态")
    private String excuteStateName;

    @Label(value = "推送时间")
    private String sendTime;

    @Label(value = "接收人")
    private List<String> recivers;

    @Label(value = "发送到web标识")
    private Boolean isSendWeb;

    @Label(value = "发送到app标识")
    private Boolean isSendApp;

    @Label("关联id")
    private String relationId;

    @Label("消息类型")
    private String msgType;

    @Label(value = "终端标识")
    private String terminal;

    @Label(value = "扩展参数")
    private Map<String, String> extras;
}
