package com.yeejoin.amos.latentdanger.business.service.impl;

import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import com.yeejoin.amos.latentdanger.business.dto.LatentDangerRo;
import com.yeejoin.amos.latentdanger.business.util.DateUtil;
import com.yeejoin.amos.latentdanger.common.enums.LatentDangerState;
import com.yeejoin.amos.latentdanger.dao.entity.LatentDanger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: xl
 * @Description: 隐患触发规则
 * @Date: 2021/11/12 14:55
 */
@Service
public class RuleDangerService {

    private final String packageId = "消息/addDangerRule";
    private final String msgType = "danger";

    private final String APP = "APP";
    private final String WEB = "WEB";
    private final String APP_WEB = "APP/WEB";

    @Autowired
    private RuleTrigger ruleTrigger;

    public Boolean addLatentDangerRule(LatentDanger latentDanger, String ruleType, String roleName) throws Exception {
        LatentDangerRo latentDangerRo = buildLatentDangerRo(latentDanger, ruleType);
        List<RoleModel> result = Privilege.roleClient.queryRoleList(roleName, null).getResult();
        if (result.size() > 0) {
            List<AgencyUserModel> userModels = Privilege.agencyUserClient.queryByRoleId(String.valueOf(result.get(0).getSequenceNbr()), null).getResult();
            List<String> userIds = userModels.stream().map(AgencyUserModel::getUserId).collect(Collectors.toList());
            latentDangerRo.setRecivers(userIds);
        }
        //触发规则
        ruleTrigger.publish(latentDangerRo, packageId, new String[0]);
        return true;
    }

    public Boolean addDangerSubmitRule(LatentDanger latentDanger, List<String> userIds, String ruleType, String excuteStateName) throws Exception {
        LatentDangerRo latentDangerRo = buildLatentDangerRo(latentDanger, ruleType);
        latentDangerRo.setExcuteStateName(excuteStateName);
        latentDangerRo.setIsSendWeb(true);
        latentDangerRo.setRecivers(userIds);

        //触发规则
        ruleTrigger.publish(latentDangerRo, packageId, new String[0]);
        return true;
    }

    private LatentDangerRo buildLatentDangerRo (LatentDanger latentDanger, String ruleType){
        LatentDangerRo latentDangerRo = new LatentDangerRo();
        BeanUtils.copyProperties(latentDanger, latentDangerRo);
        latentDangerRo.setMsgType(msgType);
        latentDangerRo.setIsSendApp(true);
        latentDangerRo.setRuleType(ruleType);
        latentDangerRo.setRelationId(String.valueOf(latentDanger.getId()));
        latentDangerRo.setSendTime(DateUtil.date2LongStr(new Date()));

        String type = null;
        latentDanger.getDangerState();
        LatentDangerState.SupervisionDangerStateEnum stateEnum =
                LatentDangerState.SupervisionDangerStateEnum.getEnumByCode(latentDanger.getDangerState());
        if (!ValidationUtil.isEmpty(stateEnum)) {
            if (stateEnum.getProcessState().equals("1")) {
                type = "1";
            } else if (stateEnum.getProcessState().equals("4")) {
                type = "2";
            }
        }

        if (!ValidationUtil.isEmpty(type)){
            Map<String, String> map = new HashMap<>();
            map.put("type", type);
            latentDangerRo.setExtras(map);
        }
        return latentDangerRo;
    }
}
