package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
* 调派单位
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PowerTransferCompanyDto", description="调派单位")
public class PowerTransferCompanyDto extends BaseDto {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "调派单据id")
    private Long powerTransferId;

    @ApiModelProperty(value = "是否只派发机构")
    private Boolean isDistributionAgencies;

    @ApiModelProperty(value = " 单位id")
    private Long companyId;

    @ApiModelProperty(value = " 单位名称")
    private String companyName;

    @ApiModelProperty(value = "任务信息")
    private String taskInformation;

    @ApiModelProperty(value = "操作人名称")
    private String recUserName;

    @ApiModelProperty(value = "资源类型")
    private String type;

    @ApiModelProperty(value = "资源数量")
    private Integer resourcesCount;

    @ApiModelProperty(value = "调派单位资源列表")
    private List<PowerTransferCompanyResourcesDto> powerTransferCompanyResourcesDtoList;

    @ApiModelProperty(value = "调派类型队伍")
    private String powerTransType;


}
