package com.yeejoin.amos.boot.module.ugp.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum ProjectInitiationEnum {
    项目立项("1","项目立项","XMLX"),
    平台审核("2","平台审核","PTSH"),
    告知申请("3","告知申请","GZSQ"),
    接受告知("4","接受告知","JSGZ"),
    审查项目("5","审查项目","SCXM"),
    提交资料("6","提交资料","TJZL"),
    审批人审批("7","审批人审批","SPRSP"),
    审核人审核("8","审核人审核","SHRSH"),
    监检科室分配("9","监检科室分配","JJKSFP"),
    监检员分配("10","监检员分配","JJYFP"),
    监检员审核("11","监检员审核","JJYSH"),
    项目关闭("12","项目关闭","XMGB"),
    接受审查意见("13","接受审查意见","JSSCYJ");

    private String status;
    private String name;
    private String code;

    public static Map<String,String> getNameByStatusMap = new HashMap<String,String>();
    public static Map<String,String> getStatusByNameMap = new HashMap<String,String>();
    public static Map<String,String> getCodeByNameMap = new HashMap<String,String>();
    static {
        for(ProjectInitiationEnum projectInitiationEnum:ProjectInitiationEnum.values()){
            getNameByStatusMap.put(projectInitiationEnum.status,projectInitiationEnum.name);
            getStatusByNameMap.put(projectInitiationEnum.name, projectInitiationEnum.status);
            getCodeByNameMap.put(projectInitiationEnum.name,projectInitiationEnum.code);
        }
    }


}
