package com.yeejoin.amos.boot.module.ugp.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum VerifyEnum {

    未通过("0","未通过","智能检验"),
    已通过("1","已通过","人工检验");

    private String status;
    private String name;

    private String type;

    public static Map<String,String> getTaskName=new HashMap<>();
    public static Map<String,String> getTaskType=new HashMap<>();
    static {
        for (VerifyEnum verifyEnum : VerifyEnum.values()){
            getTaskName.put(verifyEnum.status, verifyEnum.name);
            getTaskType.put(verifyEnum.status, verifyEnum.type);
        }

    }
}
