package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.MaterialDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Attachment;
import com.yeejoin.amos.boot.module.ugp.api.entity.Equipment;
import com.yeejoin.amos.boot.module.ugp.api.entity.Material;
import com.yeejoin.amos.boot.module.ugp.api.mapper.AttachmentMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.MaterialMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IMaterialService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 材料信息表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class MaterialServiceImpl extends BaseService<MaterialDto, Material, MaterialMapper> implements IMaterialService {

    @Autowired
    AttachmentServiceImpl attachmentServiceImpl;
    @Autowired
    AttachmentMapper attachmentMapper;
    /**
     * 分页查询
     */
    public Page<MaterialDto> queryForMaterialPage(Page<MaterialDto> page,String name ,String code) {
        return this.queryForPage(page, null, false,name,code);
    }

    /**
     * 列表查询 示例
     */
    public List<MaterialDto> queryForMaterialList() {
        return this.queryForList("", false);
    }


    /**
     * 获取材料名称跟企业id
     */
    public List<JSONObject> selectName(String installationUnitId) {
        List<JSONObject> names = new ArrayList<>();
        //添加查询条件
        QueryWrapper<Material> wrapper = new QueryWrapper<>();
        wrapper.eq("company_id", installationUnitId);

        List<Material> materials = baseMapper.selectList(wrapper);

        for (Material i : materials) {
            JSONObject name = new JSONObject();
            name.put("name", i.getName());
            name.put("SequenceNbr", i.getSequenceNbr());
            names.add(name);
        }

        return names;
    }
    /**
     * 新增材料
     */
    @Override
    public MaterialDto saveMaterial(JSONObject jsonObject){
        MaterialDto materialDto = new MaterialDto();
        materialDto.setRecDate(new Date());
        materialDto.setName(jsonObject.getString("name"));
        materialDto.setCode(jsonObject.getString("code"));
        materialDto.setMaterial(jsonObject.getString("material"));
        materialDto.setSpec(jsonObject.getString("spec"));
        materialDto.setLength(jsonObject.getDouble("length"));
        materialDto.setDiameter(jsonObject.getDouble("diameter"));
        materialDto.setWallThickness(jsonObject.getInteger("wallThickness"));
        materialDto.setManufacturer(jsonObject.getString("manufacturer"));
        materialDto.setManufactureAddr(jsonObject.getString("manufactureAddr"));
        materialDto.setManufactureDate(jsonObject.getDate("manufactureDate"));
        materialDto.setBatchNum(jsonObject.getString("batchNum"));
        MaterialDto result = this.createWithModel(materialDto);
        return result;
    }
    /**
     * 修改设备+附件信息
     * @param sequenceNbr
     * @param jsonObject
     */
    public void updateMI(Long sequenceNbr,JSONObject jsonObject){

        MaterialDto materialDto = this.queryBySeq(sequenceNbr);
        LambdaQueryWrapper<Attachment> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Attachment::getSourceId,sequenceNbr);
        Attachment attachment = attachmentServiceImpl.getOne(wrapper);
        materialDto.setName(jsonObject.getString("name"));
        materialDto.setCode(jsonObject.getString("code"));
        materialDto.setMaterial(jsonObject.getString("material"));
        materialDto.setSpec(jsonObject.getString("spec"));
        materialDto.setLength(jsonObject.getDouble("length"));
        materialDto.setDiameter(jsonObject.getDouble("diameter"));
        materialDto.setWallThickness(jsonObject.getInteger("wallThickness"));
        materialDto.setManufacturer(jsonObject.getString("manufacturer"));
        materialDto.setManufactureAddr(jsonObject.getString("manufactureAddr"));
        materialDto.setManufactureDate(jsonObject.getDate("manufactureDate"));
        materialDto.setBatchNum(jsonObject.getString("batchNum"));
        this.updateWithModel(materialDto);

        JSONArray subForm = jsonObject.getJSONArray("subForm");
        if(ValidationUtil.isEmpty(attachment)){
            attachmentServiceImpl.saveAttachment(subForm,sequenceNbr);
        }else {
            attachment.setInfo(JSON.toJSONString(subForm));
            attachmentServiceImpl.updateById(attachment);
        }
    }
    /**
     * 根据sequenceNbr查询材料的附件
     *
     * @param sequenceNbr  主键
     * @return
     */
    public JSONObject groupBySeq(Long sequenceNbr){
        MaterialDto materialDto = queryBySeq(sequenceNbr);
        AttachmentDto attachmentDto = attachmentMapper.selectAttBySeq(sequenceNbr);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name",materialDto.getName());
        jsonObject.put("code",materialDto.getCode());
        jsonObject.put("material",materialDto.getMaterial());
        jsonObject.put("spec",materialDto.getSpec());
        jsonObject.put("length",materialDto.getLength());
        jsonObject.put("diameter",materialDto.getDiameter());
        jsonObject.put("wallThickness",materialDto.getWallThickness());
        jsonObject.put("manufacturer",materialDto.getManufacturer());
        jsonObject.put("manufactureAddr",materialDto.getManufactureAddr());
        jsonObject.put("manufactureDate",materialDto.getManufactureDate());
        jsonObject.put("batchNum",materialDto.getBatchNum());
        if (attachmentDto != null){
            JSONArray jsonArray = JSON.parseArray(attachmentDto.getInfo());
            jsonObject.put("subForm",jsonArray);
        }
        return jsonObject;
    }
}