package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.Enum.OrgEnum;
import com.yeejoin.amos.boot.module.ugp.api.constants.XJConstant;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Attachment;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectInitiation;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IProjectService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目信息表服务实现类
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Service
public class ProjectServiceImpl extends BaseService<ProjectDto, Project, ProjectMapper> implements IProjectService {
    @Autowired
    ProjectMapper projectMapper;

    @Autowired
    AttachmentServiceImpl attachmentService;

    @Autowired
    ProjectInitiationServiceImpl projectInitiationService;

    @Autowired
    EquipmentServiceImpl equipmentService;


    /**
     * 分页查询
     */
    public Page<ProjectDto> queryForProjectPage(Page<ProjectDto> page ,String name,String constructionUnit) {
        Page<ProjectDto> projectDtoPage = this.queryForPage(page, null, false,name,constructionUnit);
        List<ProjectDto> projects = projectDtoPage.getRecords();
        for(ProjectDto project:projects){
            getProjectState(project);
        }
        return projectDtoPage;
    }

    private void getProjectState(ProjectDto project) {
        String state = "",insDep = "",insPerson = "";
        LambdaQueryWrapper<ProjectInitiation> lambdaQueryWrap = new LambdaQueryWrapper<>();
        lambdaQueryWrap.eq(ProjectInitiation::getInstanceId,project.getInstanceId())
                .orderByDesc(ProjectInitiation::getSequenceNbr);

        List<ProjectInitiation> projectInitiationList = projectInitiationService.list(lambdaQueryWrap);
        if(!ValidationUtil.isEmpty(projectInitiationList)){
            ProjectInitiation projectInitiation = projectInitiationList.iterator().next();
            JSONObject jsonObject = JSON.parseObject(projectInitiation.getContext());
            state = jsonObject.getString(XJConstant.PROCESS_PROJECT_STATE);
            insDep = jsonObject.getString(XJConstant.INS_DEP);
            insPerson = jsonObject.getString(XJConstant.INS_PRESON);
        }
        project.setExamineProjectState(state);
        project.setInsDep(insDep);
        project.setInsPerson(insPerson);
    }


    /**
     * 列表查询 示例
     */
    public List<ProjectDto> queryForProjectList() {
        return this.queryForList("", false);
    }

    /**
     * 查询项目名称
     */
    public List<JSONObject> selectName() {
        List<JSONObject> names = new ArrayList<>();
        //查询所有项目
        List<Project> projects = projectMapper.selectList(null);
        for (Project i : projects) {
            JSONObject name = new JSONObject();
            name.put("name", i.getName());
            name.put("sequenceNbr", i.getSequenceNbr());
            names.add(name);
        }

        return names;
    }


    /**
     * 通过多个主键sequence_nbr查询数据
     * @param ids
     * @return
     */
    public List<Project> selectByidList(List<Long> ids){
        return projectMapper.selectBatchIds(ids);
    }

    public ProjectDto getDetail(Long sequenceNbr){

        ProjectDto project = projectMapper.getDetail(sequenceNbr);
        LambdaQueryWrapper<Attachment> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Attachment::getSourceId,sequenceNbr);
        try{
            JSONArray jsonArray = JSON.parseArray(attachmentService.getOne(wrapper).getInfo());
            project.setSubForm(jsonArray);
        }catch (Exception e) {
            System.out.println("该项目暂无附件");
        }
        project.getInstanceId();
        getProjectState(project);
        return project;
    }


    public String saveOrUpdateFile(JSONObject jsonObject){
        JSONArray subForm = jsonObject.getJSONArray("subForm");
        Long sequenceNbr = jsonObject.getLong("sequenceNbr");
        LambdaQueryWrapper<Attachment> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Attachment::getSourceId,sequenceNbr);
        Attachment attachment = attachmentService.getOne(wrapper);
        if(ValidationUtil.isEmpty(attachment)){
            equipmentService.saveAttachment(subForm,sequenceNbr);
        }else {
            attachment.setInfo(JSON.toJSONString(subForm));
            attachmentService.updateById(attachment);
        }

        Project project = this.getById(sequenceNbr);
        ProjectDto projectDto = new ProjectDto();
        BeanUtils.copyProperties(project,projectDto);
        projectDto.setInsDep(jsonObject.getString("insDep"));
        projectDto.setInsDep(jsonObject.getString("insPerson"));
        projectDto.setProcessProjectState(jsonObject.getString("processProjectState"));
        boolean design=false,install=false;
        for(Object object:subForm){
            JSONObject jo = JSON.parseObject(JSON.toJSONString(object));
            String type = jo.getString("type");
            if (OrgEnum.设计单位.getKey().equals(type)){
                design=true;
            }
            if (OrgEnum.安装单位.getKey().equals(type)){
                design=true;
            }
        }

        if(design && install){
            projectInitiationService.execute(project.getInstanceId(),projectDto,"1");
        }
        this.updateById(project);
        return "ok";
    }
}