package com.yeejoin.amos.boot.module.common.api.enums;

import java.util.*;

/**
 * 警情枚举类
 */
public enum AlertCallEnum {
    //警情类型
    KRJY("960","困人救援","JQLX", false),
    GZWX("961","故障维修","JQLX", false),
    TSZX("962","投诉咨询","JQLX", false),

    //警情来源类型
    DHBJ("963","电话报警","JQLYLX", true),
    WLJR("1014","物联接入","JQLYLX", true),
    YDDSB("1015","移动端上报","JQLYLX", true),

    //处置环节
    YJJ("860", "已接警", "CZHJ", true),
    YPQ("861", "已派遣", "CZHJ", true),
    YDS("862", "已到达", "CZHJ", true),
    WBYDD("863", "维保已到达", "CZHJ", true),
    JYWC("864", "救援完成", "CZHJ", true),

    JYHF("865", "救援回访", "CZHJ", true),
    WXWC("866", "维修完成", "CZHJ", true),
    BXRYFK("867", "报修人已反馈", "CZHJ", true),
    WBYCZ("868", "维保已处置", "CZHJ", true),
    TSRYFK("869", "投诉人已反馈", "CZHJ", true),

    WJA("0", "未结案", "WCZT", true),
    YJA("1", "已结案", "WCZT", true),

    ;


    private AlertCallEnum(String code, String name, String type,Boolean isSearch){
        this.code=code;
        this.name=name;
        this.type=type;
        this.isSearch=isSearch;
    }

    private String code;

    private String name;

    private String type;
    private Boolean isSearch;

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
    public String getType() {
        return type;
    }

    public Boolean getSearch() {
        return isSearch;
    }

    public static List<HashMap<String,Object>> getTypeEnumList() {
        List<HashMap<String, Object>> list = new ArrayList<>();
        for (AlertCallEnum testEnum : EnumSet.allOf(AlertCallEnum.class)) {
            if(!testEnum.getSearch()) {
                HashMap<String, Object> map = new HashMap<>();
                map.put("title", testEnum.name);
                map.put("value", testEnum.code);
                list.add(map);
            }
        }
        return list;
    }

    public static Map<String,List<Map<String,Object>>> getSearchEnumList() {
        Map<String,List<Map<String,Object>>> searchMap = new HashMap<>();
        for (AlertCallEnum testEnum : EnumSet.allOf(AlertCallEnum.class)) {
            if(testEnum.getSearch()) {
                // 检查 searchMap 中是否存在 testEnum.type 对应的值
                List existingList = searchMap.get(testEnum.type);
                // 如果不存在，则创建一个新的 ArrayList
                if (existingList == null) {
                    existingList = new ArrayList<>();
                    searchMap.put(testEnum.type, existingList);
                }
                // 创建一个 map 并添加到 list 中
                HashMap<String, Object> map = new HashMap<>();
                map.put("title", testEnum.name);
                map.put("value", testEnum.code);
                existingList.add(map);

            }
        }
        return searchMap;
    }

}
