package com.yeejoin.amos.boot.module.common.biz.refresh.factory;

import com.yeejoin.amos.boot.module.common.api.service.IDataRefreshHandler;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Component
@RequiredArgsConstructor
public class RefreshHandlerFactory {
    private final List<IDataRefreshHandler> handlers;

    private final Map<String, IDataRefreshHandler> handlerMap = new ConcurrentHashMap<>();


    public IDataRefreshHandler getRefreshHandler(String dataType) {
        return handlerMap.computeIfAbsent(dataType, (k) -> {
            for (IDataRefreshHandler handler : handlers) {
                if (handler.supportType().equals(dataType)) {
                    return handler;
                }
            }
            throw new BadRequest("not found refresh handler for " + dataType);
        });
    }

}
